/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.analysis;

import com.ibm.nmon.analysis.AnalysisSet;
import com.ibm.nmon.analysis.AnalysisSetListener;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.analysis.AnalysisSetTableModel;
import com.ibm.nmon.gui.analysis.ByDataSetTable;
import com.ibm.nmon.gui.analysis.ByDataSetTableModel;
import com.ibm.nmon.gui.analysis.ByStatisticTableModel;
import com.ibm.nmon.gui.dnd.TableTransferHandler;
import com.ibm.nmon.gui.file.AnalysisSetFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ChoosableColumnTableModel;
import com.ibm.nmon.gui.table.DoubleCellRenderer;
import com.ibm.nmon.gui.table.IntegerCellRenderer;
import com.ibm.nmon.gui.table.StringCellRenderer;
import com.ibm.nmon.gui.table.TableColumnChooser;
import com.ibm.nmon.gui.util.ScrollingTableFix;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;

public final class SummaryTablePanel
extends JPanel
implements IntervalListener,
AnalysisSetListener,
PropertyChangeListener {
    private static final long serialVersionUID = 5581753452007550696L;
    private static final Icon TRANSPOSE_ICON = Styles.buildIcon("arrow_rotate_clockwise.png");
    private final NMONVisualizerGui gui;
    private final JFrame parent;
    private final GUITable dataSetTable;
    private final GUITable statisticsTable;
    private final JPanel statsPanel;
    private final JScrollPane scrollPane;
    private final JMenu menu;
    private final AnalysisSet analysisSet = new AnalysisSet();
    private final AnalysisSetFileChooser fileChooser;
    private final ActionListener copyTable = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GUITable table = SummaryTablePanel.this.statsPanel.isVisible() ? SummaryTablePanel.this.dataSetTable : SummaryTablePanel.this.statisticsTable;
            table.selectAll();
            SummaryTablePanel.this.gui.getMainFrame().getToolkit().getSystemClipboard().setContents(((TableTransferHandler)table.getTransferHandler()).copyAll(), null);
        }
    };
    private final ActionListener clearTable = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SummaryTablePanel.this.analysisSet.clearData();
        }
    };
    private final ActionListener saveAnalysis = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SummaryTablePanel.this.analysisSet.size() > 0) {
                SummaryTablePanel.this.fileChooser.save();
            }
        }
    };
    private final ActionListener loadAnalysis = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SummaryTablePanel.this.fileChooser.load();
        }
    };
    private final Action transposeTable = new AbstractAction(){
        private static final long serialVersionUID = 8993427044737174594L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SummaryTablePanel.this.statsPanel.isVisible()) {
                SummaryTablePanel.this.statsPanel.setVisible(false);
                SummaryTablePanel.this.scrollPane.setViewportView(SummaryTablePanel.this.statisticsTable);
                ((AnalysisSetTableModel)SummaryTablePanel.this.statisticsTable.getModel()).fireTableDataChanged();
            } else {
                SummaryTablePanel.this.statsPanel.setVisible(true);
                SummaryTablePanel.this.scrollPane.setViewportView(SummaryTablePanel.this.dataSetTable);
                ((AnalysisSetTableModel)SummaryTablePanel.this.dataSetTable.getModel()).fireTableDataChanged();
            }
            SummaryTablePanel.this.requestFocus();
        }
    };

    public SummaryTablePanel(NMONVisualizerGui gui, JFrame parent) {
        this.gui = gui;
        this.parent = parent;
        this.fileChooser = new AnalysisSetFileChooser(gui, this.analysisSet);
        this.menu = new JMenu("Table");
        this.setupMenu(parent);
        this.setLayout(new BorderLayout());
        this.statsPanel = new JPanel();
        this.setupStatsPanel();
        JPanel top = new JPanel(new BorderLayout());
        this.setupTopPanel(top);
        this.add((Component)top, "First");
        this.dataSetTable = new ByDataSetTable(gui);
        this.statisticsTable = new GUITable(gui);
        ByDataSetTableModel dataSetTableModel = new ByDataSetTableModel(gui, this.analysisSet);
        ByStatisticTableModel statTableModel = new ByStatisticTableModel(gui, this.analysisSet);
        this.dataSetTable.setModel(dataSetTableModel);
        this.statisticsTable.setModel(statTableModel);
        this.setupTable(this.dataSetTable, parent);
        this.setupTable(this.statisticsTable, parent);
        this.scrollPane = new JScrollPane(this.statisticsTable);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.scrollPane.addComponentListener(new ScrollingTableFix(this.statisticsTable, this.scrollPane));
        this.scrollPane.addComponentListener(new ScrollingTableFix(this.dataSetTable, this.scrollPane));
        this.scrollPane.setBorder(Styles.createBottomLineBorder(this));
        this.add((Component)this.scrollPane, "Center");
        JLabel label = new JLabel("Click and drag measurements from the tree onto this table");
        label.setFont(Styles.BOLD);
        label.setHorizontalAlignment(0);
        this.add((Component)label, "Last");
        this.analysisSet.addListener(this);
        ((TableRowSorter)this.statisticsTable.getRowSorter()).setRowFilter(new RowFilter<ByStatisticTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ByStatisticTableModel, ? extends Integer> entry) {
                ByStatisticTableModel model = entry.getModel();
                int idx = model.getColumnIndex(Statistic.COUNT.toString());
                if (idx == -1) {
                    throw new IllegalStateException(model + "has no column named " + Statistic.COUNT.toString());
                }
                Object value = model.getEnabledValueAt(entry.getIdentifier(), idx);
                int i = (Integer)value;
                return i != 0;
            }
        });
    }

    private void updateTable() {
        if (this.statsPanel.isVisible()) {
            ((AnalysisSetTableModel)this.dataSetTable.getModel()).fireTableDataChanged();
        } else {
            ByStatisticTableModel model = (ByStatisticTableModel)this.statisticsTable.getModel();
            model.updateGranularityMax();
            model.fireTableDataChanged();
        }
    }

    private void updateStatisticsComboBox() {
        String newName = Statistic.GRANULARITY_MAXIMUM.getName(this.gui.getGranularity());
        DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.statsPanel.getComponent(1)).getModel();
        boolean reselect = false;
        if (model.getSelectedItem() == model.getElementAt(3)) {
            reselect = true;
        }
        model.removeElementAt(3);
        model.insertElementAt(newName, 3);
        if (reselect) {
            model.setSelectedItem(newName);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.gui.getIntervalManager().addListener(this);
            this.gui.addPropertyChangeListener("granularity", this);
            this.gui.addPropertyChangeListener("granularity", (ByStatisticTableModel)this.statisticsTable.getModel());
            this.gui.getMainFrame().getJMenuBar().add((Component)this.menu, 3);
            this.gui.getMainFrame().getJMenuBar().revalidate();
            this.updateStatisticsComboBox();
            this.updateTable();
        } else {
            this.gui.getIntervalManager().removeListener(this);
            this.gui.removePropertyChangeListener("granularity", this);
            this.gui.removePropertyChangeListener("granularity", (ByStatisticTableModel)this.statisticsTable.getModel());
            this.gui.getMainFrame().getJMenuBar().remove(this.menu);
            this.gui.getMainFrame().getJMenuBar().revalidate();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void intervalAdded(Interval interval) {
    }

    @Override
    public void intervalRemoved(Interval interval) {
    }

    @Override
    public void intervalsCleared() {
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        this.updateTable();
    }

    @Override
    public void intervalRenamed(Interval interval) {
    }

    @Override
    public void analysisAdded(DataType type) {
        this.setSaveEnabled();
    }

    @Override
    public void analysisAdded(DataType type, String field) {
        this.setSaveEnabled();
    }

    @Override
    public void analysisRemoved(DataType type) {
        this.setSaveEnabled();
    }

    @Override
    public void analysisRemoved(DataType type, String field) {
        this.setSaveEnabled();
    }

    @Override
    public void analysisCleared() {
        this.setSaveEnabled();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("granularity".equals(evt.getPropertyName())) {
            this.updateTable();
            this.updateStatisticsComboBox();
        }
    }

    private void setSaveEnabled() {
        boolean enabled = this.analysisSet.size() > 0;
        this.gui.getMainFrame().getJMenuBar().getMenu(3).getItem(1).setEnabled(enabled);
    }

    private void setupTable(final JTable table, JFrame parent) {
        table.setDragEnabled(true);
        table.setTransferHandler(new TableTransferHandler(table, this.analysisSet));
        table.setDefaultRenderer(Double.class, new DoubleCellRenderer());
        table.setDefaultRenderer(Integer.class, new IntegerCellRenderer());
        table.setDefaultRenderer(String.class, new StringCellRenderer());
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JMenuItem item;
                    JPopupMenu menu = new JPopupMenu();
                    if (table.rowAtPoint(e.getPoint()) != -1 && table.getSelectedRowCount() > 0) {
                        item = new JMenuItem("Copy");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GUITable table = SummaryTablePanel.this.statsPanel.isVisible() ? SummaryTablePanel.this.dataSetTable : SummaryTablePanel.this.statisticsTable;
                                table.getTransferHandler().exportToClipboard(table, SummaryTablePanel.this.gui.getMainFrame().getToolkit().getSystemClipboard(), 1);
                            }
                        });
                        menu.add(item);
                        item = new JMenuItem("Copy All");
                        item.addActionListener(SummaryTablePanel.this.copyTable);
                        menu.add(item);
                        menu.addSeparator();
                        item = new JMenuItem("Remove");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                HashSet<String> keys = new HashSet<String>();
                                for (int row : table.getSelectedRows()) {
                                    keys.add(((AnalysisSetTableModel)table.getModel()).getKey(table.convertRowIndexToModel(row)));
                                }
                                for (String key : keys) {
                                    SummaryTablePanel.this.analysisSet.removeData(key);
                                }
                            }
                        });
                        menu.add(item);
                        menu.addSeparator();
                    }
                    item = new JMenuItem("Select Columns...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GUITable table = SummaryTablePanel.this.statsPanel.isVisible() ? SummaryTablePanel.this.dataSetTable : SummaryTablePanel.this.statisticsTable;
                            ChoosableColumnTableModel model = (ChoosableColumnTableModel)table.getModel();
                            new TableColumnChooser(SummaryTablePanel.this.gui, SummaryTablePanel.this.parent, model);
                        }
                    });
                    menu.add(item);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void setupStatsPanel() {
        this.statsPanel.setVisible(false);
        JLabel label = new JLabel("Statistic:");
        label.setHorizontalAlignment(11);
        label.setFont(Styles.LABEL);
        this.statsPanel.add(label);
        JComboBox statistic = new JComboBox();
        DefaultComboBoxModel model = (DefaultComboBoxModel)statistic.getModel();
        model.addElement(Statistic.AVERAGE.toString());
        model.addElement(Statistic.MINIMUM.toString());
        model.addElement(Statistic.MAXIMUM.toString());
        model.addElement(Statistic.GRANULARITY_MAXIMUM.getName(this.gui.getGranularity()));
        model.addElement(Statistic.STD_DEV.toString());
        model.addElement(Statistic.MEDIAN.toString());
        model.addElement(Statistic.SUM.toString());
        model.addElement(Statistic.COUNT.toString());
        statistic.setSelectedItem((Object)Statistic.AVERAGE);
        statistic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = ((JComboBox)e.getSource()).getModel().getSelectedItem();
                if (o.getClass().equals(String.class)) {
                    ((ByDataSetTableModel)SummaryTablePanel.this.dataSetTable.getModel()).setStatistic(Statistic.GRANULARITY_MAXIMUM);
                } else {
                    ((ByDataSetTableModel)SummaryTablePanel.this.dataSetTable.getModel()).setStatistic((Statistic)((Object)o));
                }
            }
        });
        this.statsPanel.add(statistic);
    }

    private void setupTopPanel(JPanel top) {
        JButton copy = new JButton("Copy");
        copy.setIcon(Styles.COPY_ICON);
        copy.addActionListener(this.copyTable);
        JButton clear = new JButton("Clear");
        clear.setIcon(Styles.CLEAR_ICON);
        clear.addActionListener(this.clearTable);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(copy);
        buttonPanel.add(clear);
        JButton transpose = new JButton("Transpose");
        transpose.setIcon(TRANSPOSE_ICON);
        transpose.addActionListener(this.transposeTable);
        JPanel temp = new JPanel();
        temp.add(transpose);
        top.add((Component)temp, "Before");
        top.add((Component)this.statsPanel, "Center");
        top.add((Component)buttonPanel, "After");
    }

    private void setupMenu(JFrame parent) {
        this.menu.setMnemonic('t');
        JMenuItem item = new JMenuItem("Load Definition...");
        item.setMnemonic('n');
        item.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        item.addActionListener(this.loadAnalysis);
        this.menu.add(item);
        item = new JMenuItem("Save Definition...");
        item.setMnemonic('s');
        item.setIcon(Styles.SAVE_ICON);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        item.addActionListener(this.saveAnalysis);
        item.setEnabled(this.analysisSet.size() > 0);
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem("Copy All");
        item.setMnemonic('a');
        item.setIcon(Styles.COPY_ICON);
        item.setAccelerator(KeyStroke.getKeyStroke(65, 192));
        item.addActionListener(this.copyTable);
        this.menu.add(item);
        item = new JMenuItem("Clear");
        item.setMnemonic('c');
        item.setIcon(Styles.CLEAR_ICON);
        item.setAccelerator(KeyStroke.getKeyStroke(127, 192));
        item.addActionListener(this.clearTable);
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem("Select Columns...");
        item.setMnemonic('m');
        item.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUITable table = SummaryTablePanel.this.statsPanel.isVisible() ? SummaryTablePanel.this.dataSetTable : SummaryTablePanel.this.statisticsTable;
                new TableColumnChooser(SummaryTablePanel.this.gui, SummaryTablePanel.this.parent, (AnalysisSetTableModel)table.getModel());
            }
        });
        this.menu.add(item);
        item = new JMenuItem("Transpose");
        item.setMnemonic('t');
        item.setIcon(TRANSPOSE_ICON);
        item.setAccelerator(KeyStroke.getKeyStroke(84, 192));
        item.addActionListener(this.transposeTable);
        this.menu.add(item);
    }
}

