/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.HighlightableBarChart;
import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.CategoryPlot;

public final class BarChartPanel
extends BaseChartPanel
implements ChartMouseListener {
    private static final long serialVersionUID = -5854445408091165201L;
    private final JMenuItem annotateBar;
    private boolean canAnnotate = false;

    public BarChartPanel(NMONVisualizerGui gui, JFrame parent) {
        super(gui, parent);
        this.addChartMouseListener(this);
        this.annotateBar = new JMenuItem("Annotate Bar");
        this.annotateBar.addActionListener(new AnnotateBarAction());
    }

    @Override
    public void highlightElement(int row, int column) {
        if (this.getChart() != null && this.getChart().getClass() == HighlightableBarChart.class) {
            boolean highlightWholeBar = ((DataTupleCategoryDataset)this.getChart().getCategoryPlot().getDataset()).categoriesHaveDifferentStats();
            for (ChartEntity entity : this.getChartRenderingInfo().getEntityCollection()) {
                if (entity.getClass() != CategoryItemEntity.class) continue;
                CategoryItemEntity categoryEntity = (CategoryItemEntity)entity;
                int currentRow = categoryEntity.getDataset().getRowIndex(categoryEntity.getRowKey());
                int currentColumn = categoryEntity.getDataset().getColumnIndex(categoryEntity.getColumnKey());
                if (highlightWholeBar) {
                    if (currentColumn != column) continue;
                    ((HighlightableBarChart)this.getChart()).highlightEntity(categoryEntity);
                    continue;
                }
                if (currentRow != row || currentColumn != column) continue;
                ((HighlightableBarChart)this.getChart()).highlightEntity(categoryEntity);
                break;
            }
        }
    }

    @Override
    public void clearHighlightedElements() {
        if (this.getChart() != null && this.getChart().getClass() == HighlightableBarChart.class) {
            ((HighlightableBarChart)this.getChart()).clearHighlights();
            this.setRefreshBuffer(true);
            this.repaint();
        }
    }

    @Override
    public void clearChart() {
        super.clearChart();
        if (this.getChart() != null) {
            this.removeAnnotationMenu();
        }
    }

    @Override
    public void addAnnotations(List<Annotation> annotations) {
        if (this.getChart() != null) {
            CategoryPlot plot = this.getChart().getCategoryPlot();
            plot.clearAnnotations();
            for (Annotation a : annotations) {
                if (!(a instanceof CategoryTextAnnotation)) continue;
                CategoryTextAnnotation annotation = (CategoryTextAnnotation)a;
                if (!plot.getCategories().contains(annotation.getCategory())) continue;
                plot.addAnnotation((CategoryAnnotation)annotation);
                this.firePropertyChange("annotation", null, annotation);
            }
        }
    }

    protected void displayPopupMenu(int x, int y) {
        Iterator i = this.getChartRenderingInfo().getEntityCollection().iterator();
        boolean valid = false;
        while (i.hasNext()) {
            CategoryItemEntity categoryEntity;
            ChartEntity entity = (ChartEntity)i.next();
            if (entity.getClass() != CategoryItemEntity.class || !(categoryEntity = (CategoryItemEntity)entity).getArea().contains(x, y)) continue;
            ((AnnotateBarAction)this.annotateBar.getActionListeners()[0]).categoryKey = (String)((Object)categoryEntity.getColumnKey());
            valid = true;
            break;
        }
        if (valid) {
            if (!this.canAnnotate) {
                this.getPopupMenu().addSeparator();
                this.getPopupMenu().add(this.annotateBar);
                this.canAnnotate = true;
            }
        } else {
            this.removeAnnotationMenu();
        }
        super.displayPopupMenu(x, y);
    }

    protected final void removeAnnotationMenu() {
        if (!this.canAnnotate) {
            boolean removed = false;
            for (Component c : this.getPopupMenu().getComponents()) {
                if (c != this.annotateBar) continue;
                this.getPopupMenu().remove(this.annotateBar);
                removed = true;
                break;
            }
            if (removed) {
                this.getPopupMenu().remove(this.getPopupMenu().getComponentCount() - 1);
            }
        }
        this.canAnnotate = false;
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity().getClass() == CategoryItemEntity.class && this.getChart() != null && this.getChart().getClass() == HighlightableBarChart.class) {
            CategoryItemEntity entity;
            HighlightableBarChart chart = (HighlightableBarChart)this.getChart();
            if (chart.isHighlighted(entity = (CategoryItemEntity)event.getEntity())) {
                chart.clearHighlights();
                this.firePropertyChange("highlightedBar", this.getRowAndColumn(entity), null);
            } else {
                chart.clearHighlights();
                chart.highlightEntity(entity);
                this.firePropertyChange("highlightedBar", null, this.getRowAndColumn(entity));
            }
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    private int[] getRowAndColumn(CategoryItemEntity entity) {
        int[] toReturn = new int[]{entity.getDataset().getRowIndex(entity.getRowKey()), entity.getDataset().getColumnIndex(entity.getColumnKey())};
        return toReturn;
    }

    private final class AnnotateBarAction
    implements ActionListener {
        String categoryKey = null;

        private AnnotateBarAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.categoryKey == null) {
                return;
            }
            String text = JOptionPane.showInputDialog(BarChartPanel.this.gui.getMainFrame(), "Annotation Text", "Annotate Bar Chart", 3);
            if (text != null) {
                if ("".equals(text = text.trim())) {
                    return;
                }
                CategoryPlot categoryPlot = BarChartPanel.this.getChart().getCategoryPlot();
                double y = categoryPlot.getRangeAxis().java2DToValue(BarChartPanel.this.clickLocation.getY(), BarChartPanel.this.getChartRenderingInfo().getPlotInfo().getDataArea(), categoryPlot.getRangeAxisEdge());
                if (y < categoryPlot.getRangeAxis().getLowerBound()) {
                    y = categoryPlot.getRangeAxis().getLowerBound();
                }
                if (y > categoryPlot.getRangeAxis().getUpperBound()) {
                    y = categoryPlot.getRangeAxis().getUpperBound();
                }
                CategoryTextAnnotation annotation = new CategoryTextAnnotation(text, (Comparable)((Object)this.categoryKey), y);
                annotation.setFont(Styles.ANNOTATION_FONT);
                annotation.setPaint((Paint)Styles.ANNOTATION_COLOR);
                BarChartPanel.this.getChart().getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
                BarChartPanel.this.firePropertyChange("annotation", null, annotation);
            }
        }
    }
}

