/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.data.DataTupleHistogramDataset;
import com.ibm.nmon.gui.chart.data.DataTupleXYDataset;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.util.CSVWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTransferable;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.ExtensionFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseChartPanel
extends ChartPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1342720624336005568L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final NMONVisualizerGui gui;
    protected final JFrame parent;
    protected Point clickLocation = null;
    private int saveHeight;
    private int saveWidth;

    protected BaseChartPanel(NMONVisualizerGui gui, JFrame parent) {
        super(null, 680, 420, 300, 200, 1024, 768, false, true, false, false, false, true);
        this.setBackground(Color.WHITE);
        this.setPreferredSize(null);
        this.removeMouseMotionListener((MouseMotionListener)((Object)this));
        this.removeMouseListener((MouseListener)((Object)this));
        this.gui = gui;
        this.parent = parent;
        this.saveWidth = 960;
        this.saveHeight = 540;
        this.setEnabled(false);
        this.clearChart();
        this.setEnforceFileExtensions(true);
    }

    public final void setChart(JFreeChart chart) {
        JFreeChart old = this.getChart();
        if (chart != old) {
            super.setChart(chart);
            if (chart != null) {
                if (old == null) {
                    this.addMouseListener((MouseListener)((Object)this));
                }
                this.firePropertyChange("chart", null, this);
            } else {
                this.getChartRenderingInfo().clear();
                this.firePropertyChange("chart", null, null);
            }
        }
    }

    public void clearChart() {
        if (this.getChart() != null) {
            this.setChart(null);
            this.removeMouseListener((MouseListener)((Object)this));
        }
    }

    public void highlightElement(int row, int column) {
    }

    public void clearHighlightedElements() {
    }

    public void setElementVisible(int row, int column, boolean visible) {
    }

    public final DataTupleDataset getDataset() {
        if (this.getChart() == null) {
            return null;
        }
        Plot plot = this.getChart().getPlot();
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = this.getChart().getXYPlot();
            DataTupleDataset dataset = (DataTupleDataset)xyPlot.getDataset(0);
            if (xyPlot.getDatasetCount() == 1) {
                return dataset;
            }
            if (dataset instanceof DataTupleXYDataset) {
                return ((DataTupleXYDataset)dataset).merge((DataTupleXYDataset)xyPlot.getDataset(1));
            }
            if (dataset instanceof DataTupleHistogramDataset) {
                return ((DataTupleHistogramDataset)dataset).merge((DataTupleHistogramDataset)xyPlot.getDataset(1));
            }
            this.logger.warn("unknown DataTupleDataset class {}, returning null", (Object)dataset.getClass().getName());
            return null;
        }
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            DataTupleCategoryDataset dataset = (DataTupleCategoryDataset)categoryPlot.getDataset(0);
            if (categoryPlot.getDatasetCount() == 1) {
                return dataset;
            }
            return dataset.merge((DataTupleCategoryDataset)categoryPlot.getDataset(1));
        }
        return null;
    }

    public final void doCopy() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ChartTransferable selection = new ChartTransferable(this.getChart(), this.saveWidth, this.saveHeight);
        systemClipboard.setContents((Transferable)selection, null);
    }

    public final void doCopyDataset() {
        DataTupleDataset data = this.getDataset();
        if (data != null) {
            StringWriter writer = new StringWriter(2048);
            try {
                CSVWriter.write(data, (Writer)writer);
                Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                systemClipboard.setContents(new StringSelection(writer.toString()), null);
            }
            catch (IOException ioe) {
                this.logger.error("error copying dataset", (Throwable)ioe);
            }
        }
    }

    public final void doSaveAs() throws IOException {
        String directory = this.gui.getPreferences().get("lastSaveDirectory", "./");
        String filename = this.validateSaveFileName(null);
        File chartFile = new File(directory, filename);
        GUIFileChooser fileChooser = new GUIFileChooser(this.gui, "Select Save Location");
        fileChooser.setSelectedFile(chartFile);
        ExtensionFileFilter filter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        fileChooser.addChoosableFileFilter((FileFilter)filter);
        if (fileChooser.showDialog((Component)((Object)this), "Save") == 0) {
            int result;
            chartFile = fileChooser.getSelectedFile();
            if (this.isEnforceFileExtensions() && !chartFile.getName().endsWith(".png")) {
                chartFile = new File(chartFile.getAbsolutePath() + ".png");
            }
            if (chartFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + chartFile.getName() + "' already exists.\nDo you want to overwrite it?", "Overwrite?", 2, 3)) != 0) {
                return;
            }
            ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.getChart(), (int)this.saveWidth, (int)this.saveHeight);
        }
        this.gui.getPreferences().put("lastSaveDirectory", chartFile.getParentFile().getAbsolutePath());
    }

    public final void setSaveSize(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("widthmust be greater than 0");
        }
        if (height < 1) {
            throw new IllegalArgumentException("heightmust be greater than 0");
        }
        this.saveWidth = width;
        this.saveHeight = height;
    }

    public final void saveChart(String directory, String filename) {
        filename = this.validateSaveFileName(filename);
        File chartFile = new File(directory, filename);
        try {
            ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.getChart(), (int)this.saveWidth, (int)this.saveHeight);
        }
        catch (IOException ioe) {
            this.logger.error("could not save chart '" + filename + "' to directory '" + directory + "'", (Throwable)ioe);
        }
    }

    public void addAnnotations(List<Annotation> annotations) {
    }

    public void addMarkers(List<Marker> markers) {
    }

    protected String validateSaveFileName(String filename) {
        if (filename == null || "".equals(filename)) {
            String title = this.getChart().getTitle().getText();
            filename = title == null || "".equals(title) ? "chart_" + this.hashCode() : title;
        }
        if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
            filename = filename + ".png";
        }
        filename.replace('\n', ' ');
        return filename;
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu popup = super.createPopupMenu(properties, copy, save, print, zoom);
        int n = 0;
        for (MenuElement element : popup.getSubElements()) {
            JMenuItem item = (JMenuItem)element;
            if (item.getText().equals("Copy")) {
                JMenuItem copyData = new JMenuItem("Copy Chart Data");
                copyData.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BaseChartPanel.this.doCopyDataset();
                    }
                });
                popup.add((Component)copyData, n + 2);
                popup.add((Component)new JPopupMenu.Separator(), n + 3);
            }
            ++n;
        }
        JMenuItem savePNG = new JMenuItem("Save Chart...");
        savePNG.setActionCommand("SAVE_AS_PNG");
        savePNG.addActionListener((ActionListener)((Object)this));
        popup.add(savePNG);
        return popup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.clickLocation = new Point(event.getX(), event.getY());
        }
        super.mousePressed(event);
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.clickLocation = new Point(event.getX(), event.getY());
        }
        super.mouseReleased(event);
    }

    public void paintComponent(Graphics g) {
        if (this.logger.isTraceEnabled()) {
            long start = System.nanoTime();
            super.paintComponent(g);
            String title = "<no title>";
            if (this.getChart() != null && this.getChart().getTitle() != null) {
                title = this.getChart().getTitle().getText();
            }
            this.logger.trace("painted chart '{}' in {} ms", (Object)title, (Object)((double)(System.nanoTime() - start) / 1000000.0));
        } else {
            super.paintComponent(g);
        }
    }
}

