/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.chart.definition.BarChartDefinition;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.chart.definition.HistogramChartDefinition;
import com.ibm.nmon.chart.definition.IntervalChartDefinition;
import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.chart.builder.BarChartBuilder;
import com.ibm.nmon.gui.chart.builder.ChartBuilderPlugin;
import com.ibm.nmon.gui.chart.builder.HistogramChartBuilder;
import com.ibm.nmon.gui.chart.builder.IntervalChartBuilder;
import com.ibm.nmon.gui.chart.builder.LineChartBuilder;
import com.ibm.nmon.gui.chart.builder.LineChartBuilderPlugin;
import com.ibm.nmon.interval.Interval;
import java.util.ArrayList;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartFactory.class);
    private final NMONVisualizerApp app;
    private final LineChartBuilder lineChartBuilder;
    private final BarChartBuilder barChartBuilder;
    private final IntervalChartBuilder intervalChartBuilder;
    private final HistogramChartBuilder histogramChartBuilder;

    public ChartFactory(NMONVisualizerApp app) {
        this.app = app;
        this.lineChartBuilder = new LineChartBuilder();
        this.lineChartBuilder.addPlugin(new LineChartBuilderPlugin(app));
        this.barChartBuilder = new BarChartBuilder();
        this.intervalChartBuilder = new IntervalChartBuilder();
        this.histogramChartBuilder = new HistogramChartBuilder();
    }

    public void setGranularity(int granularity) {
        this.lineChartBuilder.setGranularity(granularity);
        this.barChartBuilder.setGranularity(granularity);
        this.intervalChartBuilder.setGranularity(granularity);
        this.histogramChartBuilder.setGranularity(granularity);
    }

    public void setInterval(Interval interval) {
        this.lineChartBuilder.setInterval(interval);
        this.barChartBuilder.setInterval(interval);
        this.intervalChartBuilder.setInterval(interval);
        this.histogramChartBuilder.setInterval(interval);
    }

    public void addPlugin(ChartBuilderPlugin plugin) {
        this.lineChartBuilder.addPlugin(plugin);
        this.barChartBuilder.addPlugin(plugin);
        this.intervalChartBuilder.addPlugin(plugin);
        this.histogramChartBuilder.addPlugin(plugin);
    }

    public JFreeChart createChart(BaseChartDefinition definition, Iterable<? extends DataSet> dataSets) {
        long startT = System.nanoTime();
        JFreeChart chart = null;
        if (definition.getClass().equals(LineChartDefinition.class)) {
            LineChartDefinition lineDefinition = (LineChartDefinition)definition;
            this.lineChartBuilder.initChart(lineDefinition);
            for (DataSet dataSet : dataSets) {
                this.lineChartBuilder.addLine(dataSet);
            }
            chart = this.lineChartBuilder.getChart();
        } else if (definition.getClass().equals(IntervalChartDefinition.class)) {
            IntervalChartDefinition lineDefinition = (IntervalChartDefinition)definition;
            this.intervalChartBuilder.initChart(lineDefinition);
            for (DataSet dataSet : dataSets) {
                ArrayList<AnalysisRecord> analysis = new ArrayList<AnalysisRecord>();
                for (Interval i : this.app.getIntervalManager().getIntervals()) {
                    AnalysisRecord record = new AnalysisRecord(dataSet);
                    record.setInterval(i);
                    record.setGranularity(this.intervalChartBuilder.getGranularity());
                    analysis.add(record);
                }
                this.intervalChartBuilder.addLine(lineDefinition, analysis);
            }
            chart = this.intervalChartBuilder.getChart();
        } else if (definition.getClass().equals(BarChartDefinition.class)) {
            BarChartDefinition barDefinition = (BarChartDefinition)definition;
            this.barChartBuilder.initChart(barDefinition);
            for (DataSet dataSet : dataSets) {
                AnalysisRecord record = this.app.getAnalysis(dataSet);
                if (record == null) continue;
                this.barChartBuilder.addBar(record);
            }
            chart = this.barChartBuilder.getChart();
        } else if (definition.getClass().equals(HistogramChartDefinition.class)) {
            HistogramChartDefinition histogramDefinition = (HistogramChartDefinition)definition;
            this.histogramChartBuilder.initChart(histogramDefinition);
            for (DataSet dataSet : dataSets) {
                AnalysisRecord record = this.app.getAnalysis(dataSet);
                if (record == null) continue;
                this.histogramChartBuilder.addHistogram(record);
            }
            chart = this.histogramChartBuilder.getChart();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}: {} chart created in {}ms", new Object[]{dataSets, definition.getShortName(), (double)(System.nanoTime() - startT) / 1000000.0});
        }
        return chart;
    }
}

