/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.definition.ExactDataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import com.ibm.nmon.gui.chart.LineChartPanel;
import com.ibm.nmon.gui.chart.builder.LineChartBuilder;
import com.ibm.nmon.gui.chart.builder.LineChartBuilderPlugin;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.JFreeChart;

public final class DataTypeChartPanel
extends LineChartPanel
implements IntervalListener {
    private static final long serialVersionUID = 7780208253045360843L;
    private final LineChartBuilder chartBuilder = new LineChartBuilder();
    private ExactDataDefinition definition;
    private static final Map<String, String> TYPE_AXIS_NAMES;
    private static final Map<String, String> FIELD_AXIS_NAMES;
    private static final Set<String> PERCENT_AXIS_EXCEPTIONS;

    public DataTypeChartPanel(NMONVisualizerGui gui) {
        super(gui, gui.getMainFrame());
        this.chartBuilder.addPlugin(new LineChartBuilderPlugin(gui));
    }

    public void setData(DataSet data, DataType type) {
        this.setData(data, type, type.getFields());
    }

    public void setData(DataSet data, DataType type, List<String> fields) {
        this.definition = new ExactDataDefinition(data, type, fields);
        this.displayChart();
    }

    public DataSet getData() {
        return this.definition == null ? null : this.definition.getDataSet();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.gui.addPropertyChangeListener("granularity", this);
                this.gui.getIntervalManager().addListener(this);
                this.chartBuilder.setInterval(this.gui.getIntervalManager().getCurrentInterval());
                this.chartBuilder.setGranularity(this.gui.getGranularity());
                if (this.definition != null) {
                    this.displayChart();
                }
            } else {
                this.gui.removePropertyChangeListener("granularity", this);
                this.gui.getIntervalManager().removeListener(this);
                super.clearChart();
            }
        }
    }

    @Override
    public void clearChart() {
        super.clearChart();
        this.definition = null;
    }

    @Override
    protected String validateSaveFileName(String filename) {
        DataType type = this.definition.getDataType();
        List<String> fields = this.definition.getMatchingFields(type);
        return super.validateSaveFileName(this.definition.getDataSet().getHostname() + '_' + type.toString() + (fields.size() == 1 ? '_' + fields.get(0) : ""));
    }

    @Override
    public void intervalAdded(Interval interval) {
    }

    @Override
    public void intervalRemoved(Interval interval) {
    }

    @Override
    public void intervalsCleared() {
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        this.chartBuilder.setInterval(interval);
        if (this.getChart() != null) {
            this.displayChart();
        }
    }

    @Override
    public void intervalRenamed(Interval interval) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("granularity".equals(evt.getPropertyName())) {
            this.chartBuilder.setGranularity((Integer)evt.getNewValue());
            if (this.getChart() != null) {
                this.displayChart();
            }
        }
    }

    private void displayChart() {
        if (this.isEnabled()) {
            long startT = System.nanoTime();
            DataSet data = this.definition.getDataSet();
            DataType type = this.definition.getDataType();
            List<String> fields = this.definition.getMatchingFields(type);
            String fieldLabel = "";
            String axisLabel = "";
            if (fields.size() == 1) {
                fieldLabel = " - " + fields.get(0);
                axisLabel = this.getAxisLabel(type, fields.get(0));
            } else {
                axisLabel = this.getAxisLabel(type);
            }
            boolean percent = true;
            if (!type.getName().contains("%")) {
                for (String field : fields) {
                    if (!field.contains("%")) {
                        percent = false;
                        break;
                    }
                    if (PERCENT_AXIS_EXCEPTIONS.contains(field)) {
                        percent = false;
                        break;
                    }
                    if (type.getClass() != ProcessDataType.class || !this.gui.getBooleanProperty("scaleProcessesByCPUs")) continue;
                    percent = false;
                    break;
                }
            }
            LineChartDefinition chartDefinition = new LineChartDefinition("", type + fieldLabel);
            chartDefinition.setYAxisLabel(axisLabel);
            chartDefinition.setUsePercentYAxis(percent);
            this.setSaveSize(chartDefinition.getWidth(), chartDefinition.getHeight());
            this.chartBuilder.initChart(chartDefinition);
            this.chartBuilder.addLinesForData(this.definition, data, NamingMode.FIELD);
            JFreeChart chart = this.chartBuilder.getChart();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}: {}-{} chart created in {}ms", new Object[]{data.getHostname(), type.getId(), fields.size() == type.getFieldCount() ? Character.valueOf('*') : fields, (double)(System.nanoTime() - startT) / 1000000.0});
            }
            this.setChart(chart);
        }
    }

    private String getAxisLabel(DataType type) {
        int idx;
        if ("CPU_ALL".equals(type.getId())) {
            return "";
        }
        if (type.getId().startsWith("CPU")) {
            return "% CPU";
        }
        String label = TYPE_AXIS_NAMES.get(type.getId());
        if (label == null && (idx = type.getId().indexOf(40)) != -1) {
            label = TYPE_AXIS_NAMES.get(type.getId().substring(0, idx - 1));
        }
        if (label == null) {
            return "";
        }
        return label;
    }

    private String getAxisLabel(DataType type, String field) {
        String label = FIELD_AXIS_NAMES.get(field);
        if (label != null) {
            return label;
        }
        if (field.endsWith("kb/s")) {
            return "KB / s";
        }
        if (field.contains("packets")) {
            return "Packets / s";
        }
        if (field.startsWith("nr_")) {
            return "Count";
        }
        if (field.startsWith("pg")) {
            return "Pages / s";
        }
        if (field.endsWith("ch")) {
            return "Characters / s";
        }
        if (field.endsWith("_freed")) {
            return "MB";
        }
        if (field.toLowerCase().contains("megabytes")) {
            return "MB";
        }
        if (field.toLowerCase().contains("mbytes")) {
            return "MB";
        }
        if (field.toLowerCase().contains("kbytes")) {
            return "KB";
        }
        if (field.toLowerCase().contains("bytes")) {
            return "Bytes";
        }
        if (field.contains("count")) {
            return "Count";
        }
        if (field.endsWith("kb")) {
            return "KB";
        }
        if (field.endsWith("mb")) {
            return "MB";
        }
        return this.getAxisLabel(type);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.gui.removePropertyChangeListener("granularity", this);
        this.gui.getIntervalManager().removeListener(this);
    }

    static {
        HashMap<String, String> tempTypes = new HashMap<String, String>();
        HashMap<String, String> tempFields = new HashMap<String, String>();
        HashSet<String> tempExceptions = new HashSet<String>();
        tempTypes.put("DISKBSIZE", "KB / Block");
        tempTypes.put("DISKBUSY", "% Busy");
        tempTypes.put("DISKREAD", "KB / s");
        tempTypes.put("DISKWRITE", "KB / s");
        tempTypes.put("DISKRXFER", "IO Ops / s");
        tempTypes.put("DISKXFER", "IO Ops / s");
        tempTypes.put("JFSFILE", "% Used");
        tempTypes.put("JFSINODE", "% Used");
        tempTypes.put("MEMNEW", "% Used");
        tempTypes.put("NET", "KB / s");
        tempTypes.put("NETPACKET", "Packets / s");
        tempTypes.put("NETERROR", "Errors / s");
        tempTypes.put("NETSIZE", "Bytes / Packet");
        tempTypes.put("GCAFT", "MB");
        tempTypes.put("GCBEF", "MB");
        tempTypes.put("GCSINCE", "Seconds");
        tempTypes.put("GCTIME", "Milliseconds");
        tempTypes.put("GCCOUNT", "Count");
        tempTypes.put("SEA", "KB / s");
        tempTypes.put("SEAPACKET", "Packets / s");
        tempTypes.put("FCREAD", "KB / s");
        tempTypes.put("FCWRITE", "KB / s");
        tempTypes.put("FCXFERIN", "Frames / s");
        tempTypes.put("FCXFEROUT", "Frames / s");
        tempTypes.put("RESP", "Seconds");
        tempFields.put("CPUs", "Count");
        tempFields.put("CPU%", "% CPU");
        tempFields.put("User%", "% CPU");
        tempFields.put("Sys%", "% CPU");
        tempFields.put("Wait%", "% CPU");
        tempFields.put("%CPU", "% CPU");
        tempFields.put("%Usr", "% CPU");
        tempFields.put("%Sys", "% CPU");
        tempFields.put("%Wait", "% CPU");
        tempFields.put("Runnable", "Count");
        tempFields.put("pswitch", "Switches / s");
        tempFields.put("syscall", "Calls / s");
        tempFields.put("fork", "Forks / s");
        tempFields.put("forks", "Forks / s");
        tempFields.put("pgfault", "Faults / s");
        tempFields.put("pgmajfault", "Faults / s");
        tempFields.put("faults", "Faults / s");
        tempFields.put("pgpgin", "KB / s");
        tempFields.put("pgpout", "KB / s");
        tempFields.put("pswpin", "Pages / s");
        tempFields.put("pswpout", "Pages / s");
        tempFields.put("Paging", "Pages / s");
        tempFields.put("Size", "KB");
        tempFields.put("ResSet", "KB");
        tempFields.put("ResText", "KB");
        tempFields.put("ResData", "KB");
        tempFields.put("ShdLib", "KB");
        tempFields.put("MajorFault", "Pages / s");
        tempFields.put("MinorFault", "Pages / s");
        tempFields.put("cycles", "Count / s");
        tempFields.put("finalizers", "Count");
        tempFields.put("soft", "Count");
        tempFields.put("weak", "Count");
        tempFields.put("phantom", "Count");
        tempFields.put("tiltratio", "%");
        tempFields.put("requested", "Bytes");
        tempFields.put("flipped", "Objects");
        tempFields.put("tenured", "Objects");
        tempFields.put("moved", "Objects");
        tempFields.put("throughput", "Tx / s");
        tempFields.put("hits", "Hits / s");
        tempExceptions.add("EC_User%");
        tempExceptions.add("EC_Sys%");
        tempExceptions.add("EC_Wait%");
        tempExceptions.add("EC_CPU%");
        tempExceptions.add("VP_User%");
        tempExceptions.add("VP_Sys%");
        tempExceptions.add("VP_Wait%");
        tempExceptions.add("VP_CPU%");
        TYPE_AXIS_NAMES = Collections.unmodifiableMap(tempTypes);
        FIELD_AXIS_NAMES = Collections.unmodifiableMap(tempFields);
        PERCENT_AXIS_EXCEPTIONS = Collections.unmodifiableSet(tempExceptions);
    }
}

