/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;

public final class HighlightableBarChart
extends JFreeChart {
    private static final long serialVersionUID = -5389731065593870345L;
    private final Set<CategoryItemEntity> selectedEntities = new HashSet<CategoryItemEntity>();

    public HighlightableBarChart(Plot plot) {
        super(plot);
    }

    public HighlightableBarChart(String title, Plot plot) {
        super(title, plot);
    }

    public HighlightableBarChart(String title, Font titleFont, Plot plot, boolean createLegend) {
        super(title, titleFont, plot, createLegend);
    }

    void highlightEntity(CategoryItemEntity entity) {
        this.selectedEntities.add(entity);
    }

    boolean isHighlighted(CategoryItemEntity entity) {
        return this.selectedEntities.contains(entity);
    }

    public void clearHighlights() {
        this.selectedEntities.clear();
    }

    public void draw(Graphics2D g2, Rectangle2D chartArea, Point2D anchor, ChartRenderingInfo info) {
        super.draw(g2, chartArea, anchor, info);
        if (info != null) {
            for (CategoryItemEntity entity : this.selectedEntities) {
                Rectangle2D area = ((Rectangle2D)entity.getArea()).createIntersection(info.getPlotInfo().getDataArea());
                CategoryItemRenderer renderer = ((CategoryPlot)this.getPlot()).getRenderer();
                int row = entity.getDataset().getRowIndex(entity.getRowKey());
                int column = entity.getDataset().getColumnIndex(entity.getColumnKey());
                Color baseColor = (Color)renderer.getItemPaint(row, column);
                g2.setPaint(baseColor);
                g2.fill(area);
                g2.setStroke(renderer.getBaseOutlineStroke());
                g2.setPaint(baseColor.darker());
                g2.draw(area);
            }
        }
    }
}

