/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.BasicStroke;
import java.awt.Stroke;
import javax.swing.JFrame;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

public final class IntervalChartPanel
extends BaseChartPanel
implements ChartMouseListener {
    private static final long serialVersionUID = 1129587265457206809L;
    private final BasicStroke SELECTED_STROKE = new BasicStroke(5.0f);

    public IntervalChartPanel(NMONVisualizerGui gui, JFrame parent) {
        super(gui, parent);
        this.addChartMouseListener(this);
    }

    @Override
    public void highlightElement(int row, int column) {
        if (this.getChart() != null) {
            CategoryDataset dataset = ((CategoryPlot)this.getChart().getPlot()).getDataset();
            if (row >= 0 && row < dataset.getRowCount()) {
                LineAndShapeRenderer renderer = (LineAndShapeRenderer)((CategoryPlot)this.getChart().getPlot()).getRenderer();
                renderer.setSeriesStroke(row, (Stroke)this.SELECTED_STROKE);
            }
        }
    }

    @Override
    public final void clearHighlightedElements() {
        if (this.getChart() != null) {
            ((LineAndShapeRenderer)((CategoryPlot)this.getChart().getPlot()).getRenderer()).clearSeriesStrokes(false);
        }
    }

    @Override
    public void setElementVisible(int row, int column, boolean visible) {
        if (this.getChart() != null) {
            CategoryPlot plot = (CategoryPlot)this.getChart().getPlot();
            if (row >= 0 && row < plot.getDataset().getRowCount()) {
                plot.getRenderer().setSeriesVisible(row, Boolean.valueOf(visible));
            }
        }
    }

    public final void chartMouseClicked(ChartMouseEvent event) {
        CategoryItemEntity entity = null;
        int series = -1;
        if (event.getEntity().getClass() == CategoryItemEntity.class) {
            entity = (CategoryItemEntity)event.getEntity();
            series = entity.getDataset().getRowIndex(entity.getRowKey());
        } else if (event.getEntity().getClass() == LegendItemEntity.class) {
            LegendItemEntity legendEntity = (LegendItemEntity)event.getEntity();
            CategoryDataset dataset = (CategoryDataset)legendEntity.getDataset();
            series = dataset.getRowIndex(legendEntity.getSeriesKey());
            for (ChartEntity e : this.getChartRenderingInfo().getEntityCollection()) {
                CategoryItemEntity categoryEntity;
                if (e.getClass() != CategoryItemEntity.class || !(categoryEntity = (CategoryItemEntity)e).getRowKey().equals(legendEntity.getSeriesKey())) continue;
                entity = categoryEntity;
                break;
            }
        }
        if (entity != null) {
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)((CategoryPlot)this.getChart().getPlot()).getRenderer();
            Stroke oldHighlight = renderer.getSeriesStroke(series);
            renderer.clearSeriesStrokes(false);
            if (oldHighlight != this.SELECTED_STROKE) {
                renderer.setSeriesStroke(series, (Stroke)this.SELECTED_STROKE);
                this.firePropertyChange("highlightedIntervalLine", null, series);
            } else {
                renderer.setSeriesStroke(series, null);
                this.firePropertyChange("highlightedIntervalLine", series, null);
            }
        }
    }

    public final void chartMouseMoved(ChartMouseEvent event) {
    }
}

