/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart;

import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.TimeAndValueTooltipGenerator;
import com.ibm.nmon.gui.chart.annotate.DomainValueMarker;
import com.ibm.nmon.gui.chart.annotate.LineChartAnnotationDialog;
import com.ibm.nmon.gui.chart.annotate.RangeValueMarker;
import com.ibm.nmon.gui.chart.builder.LineChartBuilder;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class LineChartPanel
extends BaseChartPanel
implements ChartMouseListener {
    private static final long serialVersionUID = 7999499157941027546L;
    private final BasicStroke SELECTED_STROKE = new BasicStroke(5.0f);

    public LineChartPanel(NMONVisualizerGui gui, JFrame parent) {
        super(gui, parent);
        this.addChartMouseListener(this);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            if (enabled) {
                this.gui.addPropertyChangeListener("timeZone", this);
                this.gui.addPropertyChangeListener("chartRelativeTime", this);
                this.setAxisTimeZone(this.gui.getDisplayTimeZone());
                this.setRelativeAxis(this.gui.getBooleanProperty("chartRelativeTime"));
            } else {
                this.gui.removePropertyChangeListener("timeZone", this);
                this.gui.removePropertyChangeListener("chartRelativeTime", this);
            }
            super.setEnabled(enabled);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chartRelativeTime".equals(evt.getPropertyName())) {
            this.setRelativeAxis((Boolean)evt.getNewValue());
        } else if ("timeZone".equals(evt.getPropertyName())) {
            this.setAxisTimeZone((TimeZone)evt.getNewValue());
        } else if ("annotation".equals(evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    @Override
    public final void highlightElement(int row, int column) {
        if (this.getChart() != null && row >= 0 && row < this.getChart().getXYPlot().getDataset().getSeriesCount()) {
            XYItemRenderer renderer = this.getChart().getXYPlot().getRenderer();
            renderer.setSeriesStroke(row, (Stroke)this.SELECTED_STROKE);
        }
    }

    @Override
    public final void clearHighlightedElements() {
        if (this.getChart() != null) {
            ((AbstractRenderer)this.getChart().getXYPlot().getRenderer()).clearSeriesStrokes(false);
        }
    }

    @Override
    public void setElementVisible(int row, int column, boolean visible) {
        if (this.getChart() != null && row >= 0 && row < this.getChart().getXYPlot().getDataset().getSeriesCount()) {
            this.getChart().getXYPlot().getRenderer().setSeriesVisible(row, Boolean.valueOf(visible));
        }
    }

    @Override
    public void addAnnotations(List<Annotation> annotations) {
        if (this.getChart() != null) {
            XYPlot plot = this.getChart().getXYPlot();
            plot.clearAnnotations();
            for (Annotation a : annotations) {
                if (!(a instanceof XYAnnotation)) continue;
                XYAnnotation annotation = (XYAnnotation)a;
                plot.addAnnotation(annotation);
                this.firePropertyChange("annotation", null, annotation);
            }
        }
    }

    @Override
    public void addMarkers(List<Marker> markers) {
        if (this.getChart() != null) {
            XYPlot plot = this.getChart().getXYPlot();
            plot.clearDomainMarkers();
            plot.clearRangeMarkers();
            for (Marker marker : markers) {
                if (marker instanceof RangeValueMarker) {
                    plot.addRangeMarker(marker);
                } else if (marker instanceof DomainValueMarker) {
                    plot.addDomainMarker(marker);
                }
                this.firePropertyChange("annotation", null, marker);
            }
        }
    }

    @Override
    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu popupMenu = super.createPopupMenu(properties, copy, save, print, zoom);
        JMenuItem item = new JMenuItem("Annotate");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog dialog = new LineChartAnnotationDialog(LineChartPanel.this, LineChartPanel.this.gui, LineChartPanel.this.parent, LineChartPanel.this.clickLocation);
                dialog.setVisible(true);
            }
        });
        popupMenu.addSeparator();
        popupMenu.add(item);
        return popupMenu;
    }

    public final void chartMouseClicked(ChartMouseEvent event) {
        int series = -1;
        ChartEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity.getClass() == XYItemEntity.class) {
            series = ((XYItemEntity)event.getEntity()).getSeriesIndex();
        } else if (entity.getClass() == LegendItemEntity.class) {
            LegendItemEntity legendEntity = (LegendItemEntity)event.getEntity();
            XYDataset dataset = (XYDataset)legendEntity.getDataset();
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                if (!dataset.getSeriesKey(i).equals(legendEntity.getSeriesKey())) continue;
                series = i;
                break;
            }
        }
        if (series != -1) {
            XYItemRenderer renderer = this.getChart().getXYPlot().getRenderer();
            Stroke oldHighlight = renderer.getSeriesStroke(series);
            ((AbstractRenderer)this.getChart().getXYPlot().getRenderer()).clearSeriesStrokes(false);
            if (oldHighlight != this.SELECTED_STROKE) {
                renderer.setSeriesStroke(series, (Stroke)this.SELECTED_STROKE);
                this.firePropertyChange("highlightedLine", null, series);
            } else {
                renderer.setSeriesStroke(series, null);
                this.firePropertyChange("highlightedLine", series, null);
            }
        }
    }

    public final void chartMouseMoved(ChartMouseEvent event) {
    }

    private void setAxisTimeZone(TimeZone timeZone) {
        XYPlot plot;
        if (this.getChart() != null && (plot = this.getChart().getXYPlot()).getDomainAxis() instanceof DateAxis) {
            ((DateAxis)plot.getDomainAxis()).setTimeZone(timeZone);
            if (plot.getRenderer().getBaseToolTipGenerator().getClass() == TimeAndValueTooltipGenerator.class) {
                ((TimeAndValueTooltipGenerator)plot.getRenderer().getBaseToolTipGenerator()).setTimeZone(timeZone);
            }
        }
    }

    private void setRelativeAxis(boolean relative) {
        if (relative) {
            LineChartBuilder.setRelativeAxis(this.getChart(), this.gui.getMinSystemTime());
        } else {
            LineChartBuilder.setAbsoluteAxis(this.getChart());
        }
    }
}

