/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.annotate;

import com.ibm.nmon.gui.chart.annotate.AnnotationListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.plot.Marker;

public final class AnnotationCache {
    private static final List<Annotation> annotations = new ArrayList<Annotation>();
    private static final List<Marker> markers = new ArrayList<Marker>();
    private static final List<AnnotationListener> listeners = new ArrayList<AnnotationListener>();

    public static void add(Object o) {
        if (o instanceof Marker) {
            markers.add((Marker)o);
        } else if (o instanceof Annotation) {
            annotations.add((Annotation)o);
        } else {
            return;
        }
        for (AnnotationListener listener : listeners) {
            listener.annotationAdded();
        }
    }

    public static void addMarker(Marker marker) {
        if (marker != null) {
            markers.add(marker);
            for (AnnotationListener listener : listeners) {
                listener.annotationAdded();
            }
        }
    }

    public static void addAnnotation(Annotation annotation) {
        if (annotation != null) {
            annotations.add(annotation);
            for (AnnotationListener listener : listeners) {
                listener.annotationAdded();
            }
        }
    }

    public static List<Marker> getMarkers() {
        return Collections.unmodifiableList(markers);
    }

    public static List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(annotations);
    }

    public static boolean hasAnnotations() {
        return !markers.isEmpty() || !annotations.isEmpty();
    }

    public static void clear() {
        boolean cleared = false;
        if (!markers.isEmpty()) {
            markers.clear();
            cleared = true;
        }
        if (!annotations.isEmpty()) {
            annotations.clear();
            cleared = true;
        }
        if (cleared) {
            for (AnnotationListener listener : listeners) {
                listener.annotationsCleared();
            }
        }
    }

    public static void removeLastMarker() {
        if (!markers.isEmpty()) {
            markers.remove(markers.size() - 1);
            for (AnnotationListener listener : listeners) {
                listener.annotationRemoved();
            }
        }
    }

    public static void removeLastAnnotation() {
        if (!annotations.isEmpty()) {
            annotations.remove(annotations.size() - 1);
            for (AnnotationListener listener : listeners) {
                listener.annotationRemoved();
            }
        }
    }

    public static void addAnnotationListener(AnnotationListener listener) {
        listeners.add(listener);
    }

    public static void removeAnnoationListener(AnnotationListener listener) {
        listeners.remove(listener);
    }

    private AnnotationCache() {
    }
}

