/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.annotate;

import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.LineChartPanel;
import com.ibm.nmon.gui.chart.annotate.DomainValueMarker;
import com.ibm.nmon.gui.chart.annotate.RangeValueMarker;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public final class LineChartAnnotationDialog
extends GUIDialog {
    private static final long serialVersionUID = 6545047405002972062L;
    private final ButtonGroup lineType;
    private final JTextField annotation;
    private final JFormattedTextField yAxisValue;
    private final JFormattedTextField xAxisValue;
    private final JSpinner xAxisTime;
    private boolean useTime;
    private final JCheckBox useYAxisValue;
    private final JCheckBox useXAxisValue;
    private final XYPlot xyPlot;
    private ActionListener doAnnotation = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String line = LineChartAnnotationDialog.this.lineType.getSelection().getActionCommand();
            String text = LineChartAnnotationDialog.this.annotation.getText();
            if (text != null) {
                text = text.trim();
            }
            if ("Vertical".equals(line)) {
                DomainValueMarker marker = new DomainValueMarker(this.getX());
                marker.setLabelOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
                marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                marker.setLabel(text);
                this.formatMarker(marker);
                if (marker != null) {
                    LineChartAnnotationDialog.this.xyPlot.addDomainMarker((Marker)marker);
                    LineChartAnnotationDialog.this.firePropertyChange("annotation", null, (Object)marker);
                }
            } else if ("Horizontal".equals(line)) {
                RangeValueMarker marker = new RangeValueMarker(this.getY());
                marker.setLabelTextAnchor(TextAnchor.BASELINE_LEFT);
                marker.setLabel(text);
                this.formatMarker(marker);
                if (marker != null) {
                    LineChartAnnotationDialog.this.xyPlot.addRangeMarker((Marker)marker);
                    LineChartAnnotationDialog.this.firePropertyChange("annotation", null, (Object)marker);
                }
            } else if ("None".equals(line)) {
                if (!"".equals(text)) {
                    XYTextAnnotation annotation = new XYTextAnnotation(text, this.getX(), this.getY());
                    annotation.setFont(Styles.ANNOTATION_FONT);
                    annotation.setPaint((Paint)Styles.ANNOTATION_COLOR);
                    if (annotation != null) {
                        LineChartAnnotationDialog.this.xyPlot.addAnnotation((XYAnnotation)annotation);
                        LineChartAnnotationDialog.this.firePropertyChange("annotation", null, annotation);
                    }
                }
            } else {
                throw new IllegalStateException("unknown annotation line type");
            }
            LineChartAnnotationDialog.this.dispose();
        }

        private double getX() {
            if (LineChartAnnotationDialog.this.useTime) {
                return ((Date)LineChartAnnotationDialog.this.xAxisTime.getValue()).getTime();
            }
            return ((Number)LineChartAnnotationDialog.this.xAxisValue.getValue()).doubleValue();
        }

        private double getY() {
            return ((Number)LineChartAnnotationDialog.this.yAxisValue.getValue()).doubleValue();
        }

        private void formatMarker(ValueMarker marker) {
            marker.setStroke((Stroke)Styles.ANNOTATION_STROKE);
            marker.setPaint((Paint)Styles.ANNOTATION_COLOR);
            marker.setLabelFont(Styles.ANNOTATION_FONT);
            marker.setLabelPaint((Paint)Styles.ANNOTATION_COLOR);
        }
    };

    public LineChartAnnotationDialog(LineChartPanel lineChartPanel, NMONVisualizerGui gui, JFrame parent, Point clickLocation) {
        super(gui, parent, "Annotate Line Chart");
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.xyPlot = lineChartPanel.getChart().getXYPlot();
        this.addPropertyChangeListener(lineChartPanel);
        Rectangle2D dataArea = lineChartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double x = this.xyPlot.getDomainAxis().java2DToValue(clickLocation.getX(), dataArea, this.xyPlot.getDomainAxisEdge());
        double y = this.xyPlot.getRangeAxis().java2DToValue(clickLocation.getY(), dataArea, this.xyPlot.getRangeAxisEdge());
        if (x < this.xyPlot.getDomainAxis().getLowerBound()) {
            x = this.xyPlot.getDomainAxis().getLowerBound();
        }
        if (x > this.xyPlot.getDomainAxis().getUpperBound()) {
            x = this.xyPlot.getDomainAxis().getUpperBound();
        }
        if (y < this.xyPlot.getRangeAxis().getLowerBound()) {
            y = this.xyPlot.getRangeAxis().getLowerBound();
        }
        if (y > this.xyPlot.getRangeAxis().getUpperBound()) {
            y = this.xyPlot.getRangeAxis().getUpperBound();
        }
        this.useTime = this.xyPlot.getDomainAxis() instanceof DateAxis;
        JLabel lineStyleLabel = new JLabel("Line Style:");
        lineStyleLabel.setFont(Styles.LABEL);
        lineStyleLabel.setHorizontalAlignment(11);
        JRadioButton vertical = new JRadioButton("Vertical");
        JRadioButton horizontal = new JRadioButton("Horizontal");
        JRadioButton none = new JRadioButton("None");
        vertical.setActionCommand("Vertical");
        horizontal.setActionCommand("Horizontal");
        none.setActionCommand("None");
        this.lineType = new ButtonGroup();
        this.lineType.add(vertical);
        this.lineType.add(horizontal);
        this.lineType.add(none);
        JLabel annotationLabel = new JLabel("Annotation:");
        annotationLabel.setFont(Styles.LABEL);
        annotationLabel.setHorizontalAlignment(11);
        this.annotation = new JTextField();
        this.annotation.setColumns(5);
        JLabel xAxisLabel = new JLabel("xAxis Location:");
        xAxisLabel.setFont(Styles.LABEL);
        xAxisLabel.setHorizontalAlignment(11);
        JButton addMinute = null;
        JButton subtractMinute = null;
        JButton roundMinute = null;
        JButton roundX = null;
        JButton addOneX = null;
        JButton subtractOneX = null;
        UpdateAnnotationAction annotationUpdater = new UpdateAnnotationAction();
        if (this.useTime) {
            this.xAxisTime = new JSpinner(new SpinnerDateModel(new Date((long)x), null, null, 12));
            ((JSpinner.DateEditor)this.xAxisTime.getEditor()).getFormat().setTimeZone(gui.getDisplayTimeZone());
            double range = this.xyPlot.getDomainAxis().getUpperBound() - this.xyPlot.getDomainAxis().getLowerBound();
            if (range > 8.64E7) {
                this.xAxisTime.setEditor(new JSpinner.DateEditor(this.xAxisTime, "HH:mm:ss MMM dd"));
            } else {
                this.xAxisTime.setEditor(new JSpinner.DateEditor(this.xAxisTime, "HH:mm:ss"));
            }
            this.xAxisTime.addChangeListener(annotationUpdater);
            this.xAxisValue = null;
            addMinute = new JButton("Add 1 Min");
            subtractMinute = new JButton("Subtract 1 Min");
            roundMinute = new JButton("Round");
            addMinute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long time = ((Date)LineChartAnnotationDialog.this.xAxisTime.getValue()).getTime();
                    LineChartAnnotationDialog.this.xAxisTime.setValue(new Date(time + 60000L));
                }
            });
            subtractMinute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long time = ((Date)LineChartAnnotationDialog.this.xAxisTime.getValue()).getTime();
                    LineChartAnnotationDialog.this.xAxisTime.setValue(new Date(time - 60000L));
                }
            });
            roundMinute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long time = ((Date)LineChartAnnotationDialog.this.xAxisTime.getValue()).getTime();
                    long mod = time % 60000L;
                    if (mod >= 30000L) {
                        time += 60000L;
                    }
                    LineChartAnnotationDialog.this.xAxisTime.setValue(new Date(time / 60000L * 60000L));
                }
            });
        } else {
            this.xAxisTime = null;
            this.xAxisValue = new JFormattedTextField(Styles.NUMBER_FORMAT);
            this.xAxisValue.setValue(x);
            this.xAxisValue.addPropertyChangeListener(annotationUpdater);
            roundX = new JButton("Round");
            addOneX = new JButton("Add 1");
            subtractOneX = new JButton("Subtract 1");
            roundX.addActionListener(new RoundAction(this.xAxisValue));
            addOneX.addActionListener(new AddAction(this.xAxisValue, 1.0));
            subtractOneX.addActionListener(new AddAction(this.xAxisValue, -1.0));
        }
        JLabel yAxisLabel = new JLabel("yAxis Location:");
        yAxisLabel.setFont(Styles.LABEL);
        yAxisLabel.setHorizontalAlignment(11);
        this.yAxisValue = new JFormattedTextField(Styles.NUMBER_FORMAT);
        this.yAxisValue.setValue(y);
        this.yAxisValue.addPropertyChangeListener(annotationUpdater);
        JButton roundY = new JButton("Round");
        JButton addOneY = new JButton("Add 1");
        JButton subtractOneY = new JButton("Subtract 1");
        roundY.addActionListener(new RoundAction(this.yAxisValue));
        addOneY.addActionListener(new AddAction(this.yAxisValue, 1.0));
        subtractOneY.addActionListener(new AddAction(this.yAxisValue, -1.0));
        this.useXAxisValue = new JCheckBox("Use xAxis");
        this.useYAxisValue = new JCheckBox("Use yAxis");
        JButton ok = new JButton("OK");
        ok.addActionListener(this.doAnnotation);
        JPanel okPanel = new JPanel();
        okPanel.add(ok);
        JLabel icon = new JLabel((Icon)UIManager.get("OptionPane.questionIcon"));
        icon.setVerticalAlignment(1);
        icon.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 25));
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        buttonConstraints.gridy = 0;
        labelConstraints.insets = new Insets(5, 0, 5, 2);
        fieldConstraints.insets = new Insets(5, 0, 5, 0);
        buttonConstraints.insets = new Insets(5, 2, 5, 2);
        labelConstraints.fill = 2;
        fieldConstraints.fill = 2;
        buttonConstraints.fill = 2;
        buttonConstraints.anchor = 10;
        centerPanel.add((Component)lineStyleLabel, labelConstraints);
        buttonConstraints.gridx = 2;
        centerPanel.add((Component)vertical, buttonConstraints);
        ++buttonConstraints.gridx;
        centerPanel.add((Component)horizontal, buttonConstraints);
        ++buttonConstraints.gridx;
        centerPanel.add((Component)none, buttonConstraints);
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        ++buttonConstraints.gridy;
        fieldConstraints.gridwidth = 2;
        buttonConstraints.gridx = 3;
        centerPanel.add((Component)annotationLabel, labelConstraints);
        centerPanel.add((Component)this.annotation, fieldConstraints);
        centerPanel.add((Component)this.useXAxisValue, buttonConstraints);
        ++buttonConstraints.gridx;
        centerPanel.add((Component)this.useYAxisValue, buttonConstraints);
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        ++buttonConstraints.gridy;
        fieldConstraints.gridwidth = 1;
        buttonConstraints.gridx = 2;
        centerPanel.add((Component)xAxisLabel, labelConstraints);
        if (this.useTime) {
            centerPanel.add((Component)this.xAxisTime, fieldConstraints);
            centerPanel.add((Component)addMinute, buttonConstraints);
            ++buttonConstraints.gridx;
            centerPanel.add((Component)subtractMinute, buttonConstraints);
            ++buttonConstraints.gridx;
            centerPanel.add((Component)roundMinute, buttonConstraints);
        } else {
            centerPanel.add((Component)this.xAxisValue, fieldConstraints);
            centerPanel.add((Component)addOneX, buttonConstraints);
            ++buttonConstraints.gridx;
            centerPanel.add((Component)subtractOneX, buttonConstraints);
            ++buttonConstraints.gridx;
            centerPanel.add((Component)roundX, buttonConstraints);
        }
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        ++buttonConstraints.gridy;
        buttonConstraints.gridx = 2;
        centerPanel.add((Component)yAxisLabel, labelConstraints);
        centerPanel.add((Component)this.yAxisValue, fieldConstraints);
        centerPanel.add((Component)addOneY, buttonConstraints);
        ++buttonConstraints.gridx;
        centerPanel.add((Component)subtractOneY, buttonConstraints);
        ++buttonConstraints.gridx;
        centerPanel.add((Component)roundY, buttonConstraints);
        this.add((Component)centerPanel, "Center");
        this.add((Component)icon, "Before");
        this.add((Component)okPanel, "Last");
        this.useXAxisValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog.this.useYAxisValue.setSelected(false);
                if (LineChartAnnotationDialog.this.useXAxisValue.isSelected()) {
                    if (LineChartAnnotationDialog.this.useTime) {
                        LineChartAnnotationDialog.this.annotation.setText(((JSpinner.DateEditor)LineChartAnnotationDialog.this.xAxisTime.getEditor()).getFormat().format(LineChartAnnotationDialog.this.xAxisTime.getValue()));
                    } else {
                        LineChartAnnotationDialog.this.annotation.setText(LineChartAnnotationDialog.this.xAxisValue.getText());
                    }
                    LineChartAnnotationDialog.this.annotation.setEnabled(false);
                } else {
                    LineChartAnnotationDialog.this.annotation.setEnabled(true);
                    LineChartAnnotationDialog.this.annotation.selectAll();
                    LineChartAnnotationDialog.this.annotation.requestFocus();
                }
            }
        });
        this.useYAxisValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog.this.useXAxisValue.setSelected(false);
                if (LineChartAnnotationDialog.this.useYAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.annotation.setText(LineChartAnnotationDialog.this.yAxisValue.getText());
                    LineChartAnnotationDialog.this.annotation.setEnabled(false);
                } else {
                    LineChartAnnotationDialog.this.annotation.setEnabled(true);
                    LineChartAnnotationDialog.this.annotation.selectAll();
                    LineChartAnnotationDialog.this.annotation.requestFocus();
                }
            }
        });
        horizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog.this.useYAxisValue.setEnabled(true);
                LineChartAnnotationDialog.this.useXAxisValue.setEnabled(false);
                if (!LineChartAnnotationDialog.this.useYAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.useYAxisValue.doClick();
                }
            }
        });
        vertical.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog.this.useYAxisValue.setEnabled(false);
                LineChartAnnotationDialog.this.useXAxisValue.setEnabled(true);
                if (!LineChartAnnotationDialog.this.useXAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.useXAxisValue.doClick();
                }
            }
        });
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineChartAnnotationDialog.this.useYAxisValue.setEnabled(true);
                LineChartAnnotationDialog.this.useXAxisValue.setEnabled(true);
                if (LineChartAnnotationDialog.this.useXAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.useXAxisValue.doClick();
                }
                if (LineChartAnnotationDialog.this.useYAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.useYAxisValue.doClick();
                }
            }
        });
        this.getRootPane().setDefaultButton(ok);
        vertical.setSelected(true);
        this.useYAxisValue.setEnabled(false);
        this.useXAxisValue.doClick();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                LineChartAnnotationDialog.this.useXAxisValue.requestFocus();
            }
        });
    }

    private final class AddAction
    implements ActionListener {
        private final JFormattedTextField textField;
        private final double toAdd;

        AddAction(JFormattedTextField textField, double toAdd) {
            this.textField = textField;
            this.toAdd = toAdd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.textField.setValue(((Number)this.textField.getValue()).doubleValue() + this.toAdd);
        }
    }

    private final class RoundAction
    implements ActionListener {
        private final JFormattedTextField textField;

        RoundAction(JFormattedTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long rounded = Math.round(((Number)this.textField.getValue()).doubleValue());
            this.textField.setValue(rounded);
        }
    }

    private final class UpdateAnnotationAction
    implements PropertyChangeListener,
    ChangeListener {
        private UpdateAnnotationAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName()) || "editValid".equals(evt.getPropertyName())) {
                if (LineChartAnnotationDialog.this.useXAxisValue.isSelected()) {
                    if (LineChartAnnotationDialog.this.xAxisValue != null) {
                        LineChartAnnotationDialog.this.annotation.setText(LineChartAnnotationDialog.this.xAxisValue.getText());
                    }
                } else if (LineChartAnnotationDialog.this.useYAxisValue.isSelected()) {
                    LineChartAnnotationDialog.this.annotation.setText(LineChartAnnotationDialog.this.yAxisValue.getText());
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (LineChartAnnotationDialog.this.useXAxisValue.isSelected()) {
                LineChartAnnotationDialog.this.annotation.setText(((JSpinner.DateEditor)LineChartAnnotationDialog.this.xAxisTime.getEditor()).getFormat().format(LineChartAnnotationDialog.this.xAxisTime.getValue()));
            }
        }
    }
}

