/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.BarChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.HighlightableBarChart;
import com.ibm.nmon.gui.chart.builder.BaseChartBuilder;
import com.ibm.nmon.gui.chart.builder.GradientPainters;
import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;

public final class BarChartBuilder
extends BaseChartBuilder<BarChartDefinition> {
    @Override
    protected JFreeChart createChart() {
        CategoryAxis categoryAxis = new CategoryAxis();
        NumberAxis valueAxis = new NumberAxis();
        Object renderer = null;
        renderer = ((BarChartDefinition)this.definition).isStacked() ? new StackedBarRenderer() : new BarRenderer();
        CategoryPlot plot = new CategoryPlot((CategoryDataset)new DataTupleCategoryDataset(false), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        if (((BarChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.setDataset(1, (CategoryDataset)new DataTupleCategoryDataset(false));
            valueAxis = new NumberAxis();
            if (((BarChartDefinition)this.definition).isStacked()) {
                plot.setRenderer(1, (CategoryItemRenderer)new StackedBarRenderer());
            } else {
                plot.setRenderer(1, (CategoryItemRenderer)new BarRenderer());
            }
            plot.setRangeAxis(1, (ValueAxis)valueAxis);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        return new HighlightableBarChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
    }

    @Override
    protected void formatChart() {
        super.formatChart();
        this.chart.setTitle(((BarChartDefinition)this.definition).getTitle());
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        plot.getDomainAxis().setLabel(((BarChartDefinition)this.definition).getCategoryAxisLabel());
        plot.getRangeAxis().setLabel(((BarChartDefinition)this.definition).getYAxisLabel());
        if (((BarChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.getRangeAxis(1).setLabel(((BarChartDefinition)this.definition).getSecondaryYAxisLabel());
        }
        if (((BarChartDefinition)this.definition).usePercentYAxis()) {
            this.setPercentYAxis();
        }
        for (int i = 0; i < plot.getRendererCount(); ++i) {
            BarRenderer renderer = (BarRenderer)plot.getRenderer(i);
            renderer.setShadowVisible(false);
            renderer.setDrawBarOutline(false);
            renderer.setBarPainter((BarPainter)new GradientPainters.GradientBarPainter());
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("{1} {0} - {2} ({3})", (NumberFormat)Styles.NUMBER_FORMAT));
            renderer.setBaseOutlineStroke((Stroke)OUTLINE_STROKE);
            renderer.setBaseOutlinePaint((Paint)OUTLINE_COLOR);
            plot.getRangeAxis(i).setLabelFont(LABEL_FONT);
            plot.getRangeAxis(i).setTickLabelFont(AXIS_FONT);
        }
        plot.getDomainAxis().setCategoryMargin(0.15);
        plot.getDomainAxis().setTickMarksVisible(false);
        plot.getDomainAxis().setLowerMargin(0.015);
        plot.getDomainAxis().setUpperMargin(0.015);
        plot.getDomainAxis().setLabelFont(LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(AXIS_FONT);
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        plot.setRangeGridlineStroke((Stroke)GRID_LINES);
    }

    public void addBar(AnalysisRecord record) {
        String categoryName;
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        if (this.definition == null) {
            throw new IllegalArgumentException("BarChartDefintion cannot be null");
        }
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        DataTupleCategoryDataset dataset = (DataTupleCategoryDataset)plot.getDataset(((BarChartDefinition)this.definition).hasSecondaryYAxis() ? 1 : 0);
        DataSet data = record.getDataSet();
        Statistic previousStat = null;
        for (DataDefinition dataDefinition : ((BarChartDefinition)this.definition).getData()) {
            if (!dataDefinition.matchesHost(data)) continue;
            for (DataType type : dataDefinition.getMatchingTypes(data)) {
                for (String field : dataDefinition.getMatchingFields(type)) {
                    String barName = ((BarChartDefinition)this.definition).getBarNamingMode().getName(dataDefinition, data, type, field, this.getGranularity());
                    categoryName = ((BarChartDefinition)this.definition).getCategoryNamingMode().getName(dataDefinition, data, type, field, this.getGranularity());
                    Statistic currentStat = dataDefinition.getStatistic();
                    double value = currentStat.getValue(record, type, field);
                    if (previousStat != null && previousStat != currentStat) {
                        dataset.setCategoriesHaveDifferentStats(true);
                    }
                    previousStat = currentStat;
                    dataset.addValue(value, (Comparable)((Object)barName), (Comparable)((Object)categoryName));
                    dataset.associateTuple((Comparable)((Object)barName), (Comparable)((Object)categoryName), new DataTuple(data, type, field));
                }
            }
        }
        if (((BarChartDefinition)this.definition).isSubtractionNeeded() && dataset.getRowCount() != 0) {
            for (int i = 0; i < dataset.getColumnCount(); ++i) {
                double total = dataset.getValue(0, i).doubleValue();
                String barName = (String)((Object)dataset.getColumnKey(i));
                for (int j = 1; j < dataset.getRowCount(); ++j) {
                    double value = dataset.getValue(j, i).doubleValue() - total;
                    categoryName = (String)((Object)dataset.getRowKey(j));
                    dataset.setValue(value, (Comparable)((Object)categoryName), (Comparable)((Object)barName));
                    total += value;
                }
            }
        }
        if (this.chart.getLegend() == null) {
            int rowCount = plot.getDataset(0).getRowCount();
            if (((BarChartDefinition)this.definition).hasSecondaryYAxis()) {
                rowCount += plot.getDataset(1).getRowCount();
            }
            if (rowCount > 1) {
                this.addLegend();
            }
        }
        if (dataset.getColumnCount() > 32) {
            plot.getDomainAxis().setTickLabelFont(AXIS_FONT.deriveFont((float)AXIS_FONT.getSize() * 0.9f));
        }
        plot.configureRangeAxes();
    }

    public void setPercentYAxis() {
        NumberAxis yAxis = (NumberAxis)((CategoryPlot)this.chart.getPlot()).getRangeAxis();
        yAxis.setRange(0.0, 100.0);
    }
}

