/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.chart.definition.YAxisChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import com.ibm.nmon.gui.chart.builder.ChartBuilderPlugin;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.util.GranularityHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseChartBuilder<C extends BaseChartDefinition> {
    protected static final Font TITLE_FONT = new Font("null", 1, 18);
    protected static final Font SUBTITLE_FONT = new Font("null", 0, 16);
    protected static final Font LABEL_FONT = new Font("null", 1, 16);
    protected static final Font AXIS_FONT = new Font("null", 0, 14);
    protected static final Font LEGEND_FONT = new Font("null", 0, 14);
    protected static final Color GRID_COLOR = Color.LIGHT_GRAY;
    protected static final BasicStroke GRID_LINES = new BasicStroke(0.5f, 0, 0, 1.0f, new float[]{5.0f, 2.0f}, 0.0f);
    protected static final Color OUTLINE_COLOR = new Color(0xCCCCCC);
    protected static final BasicStroke OUTLINE_STROKE = new BasicStroke(3.0f);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Interval interval;
    private int granularity = GranularityHelper.DEFAULT_GRANULARITY;
    private List<ChartBuilderPlugin> plugins;
    protected JFreeChart chart;
    protected C definition;

    protected BaseChartBuilder() {
        this.interval = Interval.DEFAULT;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public final void setInterval(Interval interval) {
        this.interval = interval;
    }

    public final int getGranularity() {
        return this.granularity;
    }

    public final void setGranularity(int granularity) {
        if (granularity < 1) {
            throw new IllegalArgumentException("granularity must be greater than 1");
        }
        this.granularity = granularity;
    }

    public final void initChart(C definition) {
        if (definition == null) {
            throw new IllegalArgumentException("chart definition cannot be null");
        }
        this.definition = definition;
        this.chart = this.createChart();
        this.chart.setSubtitles(Collections.singletonList(new TextTitle()));
        this.formatChart();
        if (this.plugins != null) {
            for (ChartBuilderPlugin plugin : this.plugins) {
                plugin.configureChart(this.chart);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JFreeChart getChart() {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        this.updateSubtitle();
        try {
            JFreeChart jFreeChart = this.chart;
            return jFreeChart;
        }
        finally {
            this.chart = null;
            this.definition = null;
        }
    }

    public final void addPlugin(ChartBuilderPlugin plugin) {
        if (this.chart != null) {
            throw new IllegalStateException("plugins must be added before initChart() is called");
        }
        if (this.plugins == null) {
            this.plugins = new ArrayList<ChartBuilderPlugin>(2);
        }
        this.plugins.add(plugin);
    }

    protected abstract JFreeChart createChart();

    protected void formatChart() {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        this.chart.getTitle().setFont(TITLE_FONT);
        ((TextTitle)this.chart.getSubtitle(0)).setFont(SUBTITLE_FONT);
        ((TextTitle)this.chart.getSubtitle(0)).setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        Plot plot = this.chart.getPlot();
        plot.setOutlineStroke(null);
        plot.setBackgroundPaint((Paint)Color.WHITE);
    }

    protected final void addLegend() {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        LegendTitle legend = new LegendTitle((LegendItemSource)this.chart.getPlot());
        legend.setItemFont(LEGEND_FONT);
        legend.setBorder(0.0, 0.0, 0.0, 0.0);
        legend.setBackgroundPaint((Paint)Color.WHITE);
        legend.setPosition(RectangleEdge.BOTTOM);
        RectangleInsets padding = new RectangleInsets(5.0, 5.0, 5.0, 5.0);
        legend.setItemLabelPadding(padding);
        this.chart.addLegend(legend);
    }

    private final void updateSubtitle() {
        TextTitle subtitle = (TextTitle)this.chart.getSubtitle(0);
        if (((BaseChartDefinition)this.definition).getSubtitleNamingMode() == NamingMode.NONE) {
            subtitle.setText("");
            return;
        }
        HashSet<Statistic> stats = new HashSet<Statistic>();
        for (DataDefinition dataDefinition : ((BaseChartDefinition)this.definition).getData()) {
            stats.add(dataDefinition.getStatistic());
        }
        if (((BaseChartDefinition)this.definition).getSubtitleNamingMode() == NamingMode.STAT) {
            if (stats.size() == 1) {
                subtitle.setText(((Statistic)((Object)stats.iterator().next())).toString());
            } else {
                subtitle.setText("");
            }
            return;
        }
        Plot plot = this.chart.getPlot();
        Iterable<DataTuple> allTuples = null;
        DataTupleDataset data1 = null;
        DataTupleDataset data2 = null;
        boolean combineDataSets = false;
        if (this.definition instanceof YAxisChartDefinition) {
            combineDataSets = ((YAxisChartDefinition)this.definition).hasSecondaryYAxis();
        }
        if (plot instanceof XYPlot) {
            data1 = (DataTupleDataset)((XYPlot)plot).getDataset(0);
            if (combineDataSets) {
                data2 = (DataTupleDataset)((XYPlot)plot).getDataset(1);
            }
        } else {
            data1 = (DataTupleDataset)((CategoryPlot)plot).getDataset(0);
            if (combineDataSets) {
                data2 = (DataTupleDataset)((CategoryPlot)plot).getDataset(1);
            }
        }
        allTuples = data1.getAllTuples();
        if (combineDataSets) {
            HashSet<DataTuple> combined = new HashSet<DataTuple>();
            for (DataTuple tuple : allTuples) {
                combined.add(tuple);
            }
            allTuples = data2.getAllTuples();
            for (DataTuple tuple : allTuples) {
                combined.add(tuple);
            }
            allTuples = combined;
        }
        HashSet<DataSet> dataSets = new HashSet<DataSet>();
        HashSet<DataType> dataTypes = new HashSet<DataType>();
        HashSet<String> fields = new HashSet<String>();
        for (DataTuple t : allTuples) {
            dataSets.add(t.getDataSet());
            dataTypes.add(t.getDataType());
            fields.add(t.getField());
        }
        NamingMode mode = ((BaseChartDefinition)this.definition).getSubtitleNamingMode();
        if (mode == NamingMode.HOST) {
            if (dataSets.size() == 1) {
                subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.TYPE) {
            if (dataTypes.size() == 1) {
                subtitle.setText(((DataType)dataTypes.iterator().next()).toString());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.FIELD) {
            if (fields.size() == 1) {
                subtitle.setText((String)fields.iterator().next());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.HOST_TYPE) {
            if (dataTypes.size() == 1) {
                if (dataSets.size() == 1) {
                    subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname() + "-" + ((DataType)dataTypes.iterator().next()).toString());
                } else {
                    subtitle.setText(((DataType)dataTypes.iterator().next()).toString());
                }
            } else if (dataSets.size() == 1) {
                subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.HOST_FIELD) {
            if (fields.size() == 1) {
                if (dataSets.size() == 1) {
                    subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname() + "-" + (String)fields.iterator().next());
                } else {
                    subtitle.setText((String)fields.iterator().next());
                }
            } else if (dataSets.size() == 1) {
                subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.HOST_STAT) {
            if (stats.size() == 1) {
                if (dataSets.size() == 1) {
                    subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname() + "-" + ((Statistic)((Object)stats.iterator().next())).toString());
                } else {
                    subtitle.setText(((Statistic)((Object)stats.iterator().next())).toString());
                }
            } else if (dataSets.size() == 1) {
                subtitle.setText(((DataSet)dataSets.iterator().next()).getHostname());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.TYPE_FIELD) {
            if (fields.size() == 1) {
                if (dataTypes.size() == 1) {
                    subtitle.setText(((DataType)dataTypes.iterator().next()).toString() + "-" + (String)fields.iterator().next());
                } else {
                    subtitle.setText((String)fields.iterator().next());
                }
            } else if (dataTypes.size() == 1) {
                subtitle.setText(((DataType)dataTypes.iterator().next()).toString());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.TYPE_STAT) {
            if (stats.size() == 1) {
                if (dataTypes.size() == 1) {
                    subtitle.setText(((DataType)dataTypes.iterator().next()).toString() + "-" + ((Statistic)((Object)stats.iterator().next())).toString());
                } else {
                    subtitle.setText(((Statistic)((Object)stats.iterator().next())).toString());
                }
            } else if (dataTypes.size() == 1) {
                subtitle.setText(((Statistic)((Object)stats.iterator().next())).toString());
            } else {
                subtitle.setText("");
            }
        } else if (mode == NamingMode.FIELD_STAT) {
            if (stats.size() == 1) {
                if (fields.size() == 1) {
                    subtitle.setText((String)fields.iterator().next() + "-" + ((Statistic)((Object)stats.iterator().next())).toString());
                } else {
                    subtitle.setText(((Statistic)((Object)stats.iterator().next())).toString());
                }
            } else if (fields.size() == 1) {
                subtitle.setText((String)fields.iterator().next());
            } else {
                subtitle.setText("");
            }
        }
    }
}

