/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.RectangularShape;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.ui.RectangleEdge;

final class GradientPainters {
    private static void paintBar(Graphics2D g2, AbstractRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base, boolean drawBarOutline) {
        GradientPaint gp;
        Color c1;
        Color c0;
        Paint itemPaint = renderer.getItemPaint(row, column);
        if (itemPaint instanceof Color) {
            c0 = (Color)itemPaint;
            c1 = new Color(Math.max((int)((float)c0.getRed() * 0.75f), 0), Math.max((int)((float)c0.getGreen() * 0.75f), 0), Math.max((int)((float)c0.getBlue() * 0.75f), 0));
        } else if (itemPaint instanceof GradientPaint) {
            gp = (GradientPaint)itemPaint;
            c0 = gp.getColor1();
            c1 = gp.getColor2();
        } else {
            c0 = Color.BLUE;
            c1 = c0.darker();
        }
        if (c0.getAlpha() == 0) {
            return;
        }
        gp = null;
        if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            gp = new GradientPaint((float)bar.getMinX(), 0.0f, c0, (float)bar.getMaxX(), 0.0f, c1);
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            gp = new GradientPaint(0.0f, (float)bar.getMinY(), c0, 0.0f, (float)bar.getMaxY(), c1);
        }
        g2.setPaint(gp);
        g2.fill(bar);
        if (drawBarOutline) {
            Stroke stroke = renderer.getItemOutlineStroke(row, column);
            Paint paint = renderer.getItemOutlinePaint(row, column);
            if (stroke != null && paint != null) {
                g2.setStroke(stroke);
                g2.setPaint(paint);
                g2.draw(bar);
            }
        }
    }

    private GradientPainters() {
    }

    static final class GradientXYBarPainter
    extends StandardXYBarPainter {
        private static final long serialVersionUID = 7910681188097939458L;

        GradientXYBarPainter() {
        }

        public void paintBar(Graphics2D g2, XYBarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base) {
            GradientPainters.paintBar(g2, (AbstractRenderer)renderer, row, column, bar, base, renderer.isDrawBarOutline());
        }
    }

    static final class GradientBarPainter
    extends StandardBarPainter {
        private static final long serialVersionUID = -5663235468496023390L;

        GradientBarPainter() {
        }

        public void paintBar(Graphics2D g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base) {
            GradientPainters.paintBar(g2, (AbstractRenderer)renderer, row, column, bar, base, renderer.isDrawBarOutline());
        }
    }
}

