/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.HistogramChartDefinition;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.builder.BaseChartBuilder;
import com.ibm.nmon.gui.chart.builder.GradientPainters;
import com.ibm.nmon.gui.chart.data.DataTupleHistogramDataset;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public final class HistogramChartBuilder
extends BaseChartBuilder<HistogramChartDefinition> {
    private int insetTop = 5;

    @Override
    protected JFreeChart createChart() {
        DataTupleHistogramDataset dataset = new DataTupleHistogramDataset();
        NumberAxis dataAxis = new NumberAxis();
        dataAxis.setAutoRangeIncludesZero(false);
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setAutoRangeIncludesZero(true);
        XYBarRenderer renderer = new XYBarRenderer();
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)dataAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        if (((HistogramChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.setDataset(1, (XYDataset)new DataTupleHistogramDataset());
            valueAxis = new NumberAxis();
            valueAxis.setAutoRangeIncludesZero(true);
            plot.setRangeAxis(1, (ValueAxis)valueAxis);
            plot.setRenderer(1, (XYItemRenderer)renderer);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        this.insetTop = 5;
        return new JFreeChart("", null, (Plot)plot, false);
    }

    @Override
    protected void formatChart() {
        int i;
        super.formatChart();
        this.chart.setTitle(((HistogramChartDefinition)this.definition).getTitle());
        XYPlot plot = this.chart.getXYPlot();
        if ("".equals(((HistogramChartDefinition)this.definition).getXAxisLabel())) {
            plot.getDomainAxis().setLabel("Values");
        } else {
            plot.getDomainAxis().setLabel(((HistogramChartDefinition)this.definition).getXAxisLabel());
        }
        if (((HistogramChartDefinition)this.definition).getXAxisRange() != null) {
            plot.getDomainAxis().setRange(((HistogramChartDefinition)this.definition).getXAxisRange());
        }
        if ("".equals(((HistogramChartDefinition)this.definition).getYAxisLabel())) {
            if (((HistogramChartDefinition)this.definition).usePercentYAxis()) {
                plot.getRangeAxis().setLabel("Percent");
            } else {
                plot.getRangeAxis().setLabel("Count");
            }
        } else {
            plot.getRangeAxis().setLabel(((HistogramChartDefinition)this.definition).getYAxisLabel());
        }
        HistogramDataset dataset = (HistogramDataset)plot.getDataset();
        if (((HistogramChartDefinition)this.definition).usePercentYAxis()) {
            NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
            yAxis.setRange(0.0, 100.0);
            dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        } else {
            dataset.setType(HistogramType.FREQUENCY);
        }
        if (((HistogramChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.getRangeAxis(1).setLabel(((HistogramChartDefinition)this.definition).getSecondaryYAxisLabel());
            dataset = (HistogramDataset)plot.getDataset(1);
            dataset.setType(HistogramType.FREQUENCY);
        }
        for (i = 0; i < plot.getRendererCount(); ++i) {
            XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer(i);
            renderer = (XYBarRenderer)plot.getRenderer();
            renderer.setMargin(0.15);
            renderer.setShadowVisible(false);
            renderer.setDrawBarOutline(false);
            renderer.setBarPainter((XYBarPainter)new GradientPainters.GradientXYBarPainter());
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{1} - {2}", (NumberFormat)Styles.NUMBER_FORMAT, (NumberFormat)Styles.NUMBER_FORMAT));
            renderer.setBaseOutlineStroke((Stroke)OUTLINE_STROKE);
            renderer.setBaseOutlinePaint((Paint)OUTLINE_COLOR);
        }
        for (i = 0; i < plot.getRangeAxisCount(); ++i) {
            plot.getRangeAxis(i).setLabelFont(LABEL_FONT);
            plot.getRangeAxis(i).setTickLabelFont(AXIS_FONT);
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(AXIS_FONT);
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        plot.setRangeGridlineStroke((Stroke)GRID_LINES);
    }

    public void addHistogram(AnalysisRecord analysis) {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        if (this.definition == null) {
            throw new IllegalArgumentException("HistogramChartDefintion cannot be null");
        }
        long start = System.nanoTime();
        XYPlot plot = this.chart.getXYPlot();
        DataTupleHistogramDataset dataset = (DataTupleHistogramDataset)plot.getDataset(((HistogramChartDefinition)this.definition).hasSecondaryYAxis() ? 1 : 0);
        DataSet data = analysis.getDataSet();
        for (DataDefinition dataDefinition : ((HistogramChartDefinition)this.definition).getData()) {
            if (!dataDefinition.matchesHost(data)) continue;
            for (DataType type : dataDefinition.getMatchingTypes(data)) {
                for (String field : dataDefinition.getMatchingFields(type)) {
                    String fieldName = ((HistogramChartDefinition)this.definition).getHistogramNamingMode().getName(dataDefinition, data, type, field, this.getGranularity());
                    ArrayList<Double> values = new ArrayList<Double>(data.getRecordCount());
                    for (DataRecord record : data.getRecords(analysis.getInterval())) {
                        if (!record.hasData(type)) continue;
                        values.add(record.getData(type)[type.getFieldIndex(field)]);
                    }
                    double[] toAdd = new double[values.size()];
                    for (int i = 0; i < toAdd.length; ++i) {
                        toAdd[i] = (Double)values.get(i);
                    }
                    if (((HistogramChartDefinition)this.definition).getXAxisRange() == null) {
                        dataset.addSeries((Comparable)((Object)fieldName), toAdd, ((HistogramChartDefinition)this.definition).getBins());
                    } else {
                        dataset.addSeries((Comparable)((Object)fieldName), toAdd, ((HistogramChartDefinition)this.definition).getBins(), ((HistogramChartDefinition)this.definition).getXAxisRange().getLowerBound(), ((HistogramChartDefinition)this.definition).getXAxisRange().getUpperBound());
                    }
                    dataset.associateTuple((Comparable)((Object)fieldName), null, new DataTuple(data, type, field));
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("{}: {}-{} added {} data points to chart '{}'  in {}ms", new Object[]{data, type, field, toAdd.length, ((HistogramChartDefinition)this.definition).getTitle(), (double)(System.nanoTime() - start) / 1000000.0});
                }
            }
        }
        if (((HistogramChartDefinition)this.definition).getMarkerCount() > 0 && dataset.getSeriesCount() > 0) {
            int seriesCount = dataset.getSeriesCount();
            boolean useFieldName = seriesCount > 1;
            for (int i = 0; i < seriesCount; ++i) {
                DataTuple tuple = dataset.getTuple(i, 0);
                for (Statistic stat : ((HistogramChartDefinition)this.definition).getMarkers()) {
                    double value = stat.getValue(analysis, tuple.getDataType(), tuple.getField());
                    ValueMarker marker = new ValueMarker(value);
                    marker.setLabel((useFieldName ? dataset.getSeriesKey(i) + " " : "") + stat.getName(this.getGranularity()) + ": " + Styles.NUMBER_FORMAT.format(value));
                    marker.setStroke((Stroke)Styles.ANNOTATION_STROKE);
                    marker.setPaint((Paint)Styles.ANNOTATION_COLOR);
                    marker.setLabelFont(Styles.ANNOTATION_FONT);
                    marker.setLabelPaint((Paint)Styles.ANNOTATION_COLOR);
                    marker.setLabelOffset(new RectangleInsets((double)this.insetTop, 5.0, 5.0, 10.0));
                    marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                    plot.addDomainMarker((Marker)marker);
                    this.insetTop += 20;
                }
            }
        }
        if (this.chart.getLegend() == null) {
            int seriesCount = this.chart.getXYPlot().getDataset(0).getSeriesCount();
            if (((HistogramChartDefinition)this.definition).hasSecondaryYAxis()) {
                seriesCount += this.chart.getXYPlot().getDataset(1).getSeriesCount();
            }
            if (seriesCount > 1) {
                this.addLegend();
            }
        }
    }
}

