/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.chart.definition.IntervalChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.gui.chart.builder.BaseChartBuilder;
import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

public final class IntervalChartBuilder
extends BaseChartBuilder<IntervalChartDefinition> {
    @Override
    protected JFreeChart createChart() {
        CategoryAxis categoryAxis = new CategoryAxis();
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setAutoRangeIncludesZero(true);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setBaseSeriesVisible(true, false);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)new DataTupleCategoryDataset(true), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        if (((IntervalChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.setDataset(1, (CategoryDataset)new DataTupleCategoryDataset(true));
            valueAxis = new NumberAxis();
            valueAxis.setAutoRangeIncludesZero(true);
            renderer = new LineAndShapeRenderer();
            renderer.setBaseSeriesVisible(true, false);
            plot.setRenderer(1, (CategoryItemRenderer)renderer);
            plot.setRangeAxis(1, (ValueAxis)valueAxis);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        return new JFreeChart("", null, (Plot)plot, false);
    }

    @Override
    protected void formatChart() {
        super.formatChart();
        this.chart.setTitle(((IntervalChartDefinition)this.definition).getTitle());
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        plot.getDomainAxis().setLabel(((IntervalChartDefinition)this.definition).getXAxisLabel());
        plot.getRangeAxis().setLabel(((IntervalChartDefinition)this.definition).getYAxisLabel());
        if (((IntervalChartDefinition)this.definition).usePercentYAxis()) {
            this.setPercentYAxis();
        }
        for (int i = 0; i < plot.getRendererCount(); ++i) {
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer(i);
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("{1} {0} - {2}", (NumberFormat)new DecimalFormat("#,##0.00")));
            plot.getRangeAxis(i).setLabelFont(LABEL_FONT);
            plot.getRangeAxis(i).setTickLabelFont(AXIS_FONT);
        }
        plot.getDomainAxis().setLowerMargin(0.015);
        plot.getDomainAxis().setUpperMargin(0.015);
        plot.getDomainAxis().setLabelFont(LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(AXIS_FONT);
        plot.getDomainAxis().setLowerMargin(0.015);
        plot.getDomainAxis().setUpperMargin(0.015);
        plot.getDomainAxis().setCategoryMargin(0.0);
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        plot.setRangeGridlineStroke((Stroke)GRID_LINES);
    }

    public void addLine(IntervalChartDefinition lineDefinition, List<AnalysisRecord> records) {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        if (this.definition == null) {
            throw new IllegalArgumentException("IntervalChartDefintion cannot be null");
        }
        if (records == null || records.isEmpty()) {
            return;
        }
        if (records.size() > 4) {
            ((CategoryPlot)this.chart.getPlot()).getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        DataTupleCategoryDataset dataset = (DataTupleCategoryDataset)((CategoryPlot)this.chart.getPlot()).getDataset(lineDefinition.hasSecondaryYAxis() ? 1 : 0);
        DataSet data = records.get(0).getDataSet();
        HashMap<String, Integer> usedIntervalNames = new HashMap<String, Integer>(records.size());
        for (DataDefinition definition : lineDefinition.getData()) {
            if (!definition.matchesHost(data)) continue;
            for (DataType type : definition.getMatchingTypes(data)) {
                List<String> fields = definition.getMatchingFields(type);
                for (String field : fields) {
                    String name = lineDefinition.getLineNamingMode().getName(definition, data, type, field, this.getGranularity());
                    for (AnalysisRecord record : records) {
                        Integer count;
                        double value = definition.getStatistic().getValue(record, type, field);
                        String intervalName = record.getInterval().getName();
                        if ("".equals(intervalName)) {
                            intervalName = record.getInterval().getDuration() >= 86400000L ? TimeFormatCache.formatDateTime(record.getInterval().getStart()) + '-' + TimeFormatCache.formatDateTime(record.getInterval().getEnd()) : TimeFormatCache.formatTime(record.getInterval().getStart()) + '-' + TimeFormatCache.formatTime(record.getInterval().getEnd());
                        }
                        if ((count = (Integer)usedIntervalNames.get(intervalName)) != null) {
                            int i = dataset.getColumnIndex((Comparable)((Object)name));
                            if (i != -1) {
                                count = count + 1;
                                usedIntervalNames.put(intervalName, count);
                                intervalName = intervalName + " " + count;
                            }
                        } else {
                            usedIntervalNames.put(intervalName, 0);
                        }
                        dataset.addValue(value, (Comparable)((Object)name), (Comparable)((Object)intervalName));
                        dataset.associateTuple((Comparable)((Object)name), (Comparable)((Object)intervalName), new DataTuple(record.getDataSet(), type, field));
                    }
                }
            }
        }
        if (this.chart.getLegend() == null) {
            int rowCount = this.chart.getCategoryPlot().getDataset(0).getRowCount();
            if (((IntervalChartDefinition)this.definition).hasSecondaryYAxis()) {
                rowCount += this.chart.getCategoryPlot().getDataset(1).getRowCount();
            }
            if (rowCount > 1) {
                this.addLegend();
            }
        }
    }

    public void setPercentYAxis() {
        NumberAxis yAxis = (NumberAxis)((CategoryPlot)this.chart.getPlot()).getRangeAxis();
        yAxis.setRange(0.0, 100.0);
    }
}

