/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import com.ibm.nmon.gui.chart.builder.BaseChartBuilder;
import com.ibm.nmon.gui.chart.data.DataTupleXYDataset;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.util.RelativeDateFormat;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.UnitType;

public class LineChartBuilder
extends BaseChartBuilder<LineChartDefinition> {
    private final XYToolTipGenerator tooltipGenerator = new XYToolTipGenerator(){
        private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
        private final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#,##0.000");

        public String generateToolTip(XYDataset dataset, int series, int item) {
            return (dataset.getSeriesCount() > 1 ? dataset.getSeriesKey(series) + " " : "") + this.DATE_FORMAT.format(new Date((long)dataset.getXValue(series, item))) + " - " + this.NUMBER_FORMAT.format(dataset.getYValue(series, item));
        }
    };

    @Override
    protected JFreeChart createChart() {
        Object renderer;
        DateAxis timeAxis = new DateAxis();
        NumberAxis valueAxis = new NumberAxis();
        valueAxis.setAutoRangeIncludesZero(true);
        DataTupleXYDataset dataset = new DataTupleXYDataset(((LineChartDefinition)this.definition).isStacked());
        XYPlot plot = null;
        if (((LineChartDefinition)this.definition).isStacked()) {
            renderer = new StackedXYAreaRenderer2();
            renderer.setBaseSeriesVisible(true, false);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        } else {
            renderer = new StandardXYItemRenderer();
            renderer.setBaseSeriesVisible(true, false);
            plot = new XYPlot((XYDataset)dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        }
        if (((LineChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.setDataset(1, (XYDataset)new DataTupleXYDataset(((LineChartDefinition)this.definition).isStacked()));
            valueAxis = new NumberAxis();
            valueAxis.setAutoRangeIncludesZero(true);
            renderer = new StandardXYItemRenderer();
            renderer.setBaseSeriesVisible(true, false);
            plot.setRangeAxis(1, (ValueAxis)valueAxis);
            plot.setRenderer(1, (XYItemRenderer)renderer);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        return new JFreeChart("", null, (Plot)plot, false);
    }

    @Override
    protected void formatChart() {
        Object renderer;
        super.formatChart();
        this.chart.setTitle(((LineChartDefinition)this.definition).getTitle());
        XYPlot plot = this.chart.getXYPlot();
        plot.getDomainAxis().setLabel(((LineChartDefinition)this.definition).getXAxisLabel());
        plot.getRangeAxis().setLabel(((LineChartDefinition)this.definition).getYAxisLabel());
        if (((LineChartDefinition)this.definition).usePercentYAxis()) {
            LineChartBuilder.setPercentYAxis(this.chart);
        }
        if (((LineChartDefinition)this.definition).isStacked()) {
            renderer = (StackedXYAreaRenderer2)plot.getRenderer();
            renderer.setLegendArea((Shape)new Rectangle(10, 10));
            renderer.setBaseToolTipGenerator(this.tooltipGenerator);
        } else {
            renderer = (StandardXYItemRenderer)plot.getRenderer(0);
            ((StandardXYItemRenderer)renderer).setBaseShapesVisible(true);
            ((StandardXYItemRenderer)renderer).setBaseShapesFilled(true);
            ((StandardXYItemRenderer)renderer).setPlotDiscontinuous(true);
            ((StandardXYItemRenderer)renderer).setGapThresholdType(UnitType.ABSOLUTE);
            this.recalculateGapThreshold(0);
            renderer.setBaseToolTipGenerator(this.tooltipGenerator);
        }
        if (((LineChartDefinition)this.definition).hasSecondaryYAxis()) {
            plot.getRangeAxis(1).setLabel(((LineChartDefinition)this.definition).getSecondaryYAxisLabel());
            renderer = (StandardXYItemRenderer)plot.getRenderer(1);
            ((StandardXYItemRenderer)renderer).setBaseShapesVisible(true);
            ((StandardXYItemRenderer)renderer).setBaseShapesFilled(true);
            ((StandardXYItemRenderer)renderer).setPlotDiscontinuous(true);
            ((StandardXYItemRenderer)renderer).setGapThresholdType(UnitType.ABSOLUTE);
            this.recalculateGapThreshold(1);
            renderer.setBaseToolTipGenerator(this.tooltipGenerator);
        }
        for (int i = 0; i < plot.getRangeAxisCount(); ++i) {
            plot.getRangeAxis(i).setLabelFont(LABEL_FONT);
            plot.getRangeAxis(i).setTickLabelFont(AXIS_FONT);
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(AXIS_FONT);
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        plot.setRangeGridlineStroke((Stroke)GRID_LINES);
    }

    public void addLine(DataSet data) {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        for (DataDefinition dataDefinition : ((LineChartDefinition)this.definition).getData()) {
            DataTupleXYDataset dataset = (DataTupleXYDataset)this.chart.getXYPlot().getDataset(dataDefinition.usesSecondaryYAxis() ? 1 : 0);
            this.addMatchingData(dataset, dataDefinition, data, ((LineChartDefinition)this.definition).getLineNamingMode());
        }
        this.updateChart();
    }

    public void addLinesForData(DataDefinition definition, DataSet data, NamingMode lineNamingMode) {
        if (this.chart == null) {
            throw new IllegalStateException("initChart() must be called first");
        }
        DataTupleXYDataset dataset = (DataTupleXYDataset)this.chart.getXYPlot().getDataset(definition.usesSecondaryYAxis() ? 1 : 0);
        this.addMatchingData(dataset, definition, data, lineNamingMode);
        this.updateChart();
    }

    private void addMatchingData(DataTupleXYDataset dataset, DataDefinition definition, DataSet data, NamingMode lineNamingMode) {
        if (definition == null) {
            throw new IllegalArgumentException("LineChartDefintion cannot be null");
        }
        if (definition.matchesHost(data)) {
            for (DataType type : definition.getMatchingTypes(data)) {
                List<String> fields = definition.getMatchingFields(type);
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                for (String field : fields) {
                    fieldNames.add(lineNamingMode.getName(definition, data, type, field, this.getGranularity()));
                }
                this.addData(dataset, data, type, fields, fieldNames);
            }
        }
    }

    private void addData(DataTupleXYDataset dataset, DataSet data, DataType type, List<String> fields, List<String> fieldNames) {
        long start = System.nanoTime();
        double[] totals = new double[fields.size()];
        Arrays.fill(totals, Double.NaN);
        int n = 0;
        long lastOutputTime = Math.max(this.getInterval().getStart(), data.getStartTime());
        for (DataRecord record : data.getRecords(this.getInterval())) {
            if (record != null && record.hasData(type)) {
                for (int i = 0; i < fields.size(); ++i) {
                    double value;
                    if (!type.hasField(fields.get(i)) || Double.isNaN(value = record.getData(type, fields.get(i)))) continue;
                    if (Double.isNaN(totals[i])) {
                        totals[i] = 0.0;
                    }
                    int n2 = i;
                    totals[n2] = totals[n2] + value;
                }
                ++n;
            }
            if (n <= 0 || record.getTime() - lastOutputTime < (long)this.getGranularity()) continue;
            FixedMillisecond graphTime = new FixedMillisecond(record.getTime());
            for (int i = 0; i < fields.size(); ++i) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(new Date(record.getTime()) + "\t" + type + "\t" + totals[i] + "\t" + totals[i] / (double)n + "\t" + n + "\t" + (record.getTime() - lastOutputTime));
                }
                if (!Double.isNaN(totals[i])) {
                    dataset.add((TimePeriod)graphTime, totals[i] / (double)n, (Comparable)((Object)fieldNames.get(i)), false);
                }
                totals[i] = Double.NaN;
            }
            lastOutputTime = record.getTime();
            n = 0;
        }
        long endTime = data.getEndTime();
        if (endTime != lastOutputTime) {
            FixedMillisecond graphTime = new FixedMillisecond(endTime);
            for (int i = 0; i < fields.size(); ++i) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(new Date(endTime) + "\t" + type + "\t" + totals[i] + "\t" + totals[i] / (double)n + "\t" + n + "\t" + (endTime - lastOutputTime));
                }
                if (Double.isNaN(totals[i])) continue;
                dataset.add((TimePeriod)graphTime, totals[i] / (double)n, (Comparable)((Object)fieldNames.get(i)), false);
            }
        }
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            int idx = fieldNames.indexOf(dataset.getSeriesKey(i));
            if (idx == -1) continue;
            dataset.associateTuple((Comparable)((Object)fieldNames.get(idx)), null, new DataTuple(data, type, fields.get(idx)));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}: {}-({} fields) added {} data points to chart '{}'  in {}ms", new Object[]{data, type, fieldNames.size(), dataset.getItemCount(), ((LineChartDefinition)this.definition).getTitle(), (double)(System.nanoTime() - start) / 1000000.0});
        }
    }

    private void updateChart() {
        this.recalculateGapThreshold(0);
        if (((LineChartDefinition)this.definition).hasSecondaryYAxis()) {
            this.recalculateGapThreshold(1);
        }
        this.chart.getXYPlot().configureRangeAxes();
        if (this.chart.getLegend() == null) {
            int seriesCount = this.chart.getXYPlot().getDataset(0).getSeriesCount();
            if (((LineChartDefinition)this.definition).hasSecondaryYAxis()) {
                seriesCount += this.chart.getXYPlot().getDataset(1).getSeriesCount();
            }
            if (seriesCount > 1) {
                this.addLegend();
            }
        }
    }

    private void recalculateGapThreshold(int datasetIndex) {
        if (((LineChartDefinition)this.definition).isStacked() && datasetIndex == 0) {
            return;
        }
        long start = System.nanoTime();
        XYPlot plot = this.chart.getXYPlot();
        if (plot.getDataset(datasetIndex).getItemCount(0) > 0) {
            DataTupleXYDataset dataset = (DataTupleXYDataset)plot.getDataset(datasetIndex);
            int seriesCount = dataset.getSeriesCount();
            double[] averageDistance = new double[seriesCount];
            int[] count = new int[seriesCount];
            double[] previousX = new double[seriesCount];
            Arrays.fill(averageDistance, 0.0);
            Arrays.fill(count, 0);
            Arrays.fill(previousX, dataset.getXValue(0, 0));
            for (int i = 1; i < dataset.getItemCount(0); ++i) {
                double currentX = dataset.getXValue(0, i);
                for (int j = 0; j < seriesCount; ++j) {
                    double y = dataset.getYValue(j, i);
                    if (Double.isNaN(y)) continue;
                    int n = j;
                    averageDistance[n] = averageDistance[n] + (currentX - previousX[j]);
                    previousX[j] = currentX;
                    int n2 = j;
                    count[n2] = count[n2] + 1;
                }
            }
            double maxAverage = Double.MIN_VALUE;
            for (int i = 0; i < seriesCount; ++i) {
                int n = i;
                averageDistance[n] = averageDistance[n] / (double)count[i];
                if (!(averageDistance[i] > maxAverage)) continue;
                maxAverage = averageDistance[i];
            }
            ((StandardXYItemRenderer)plot.getRenderer(datasetIndex)).setGapThreshold(maxAverage * 1.25);
        } else {
            ((StandardXYItemRenderer)plot.getRenderer()).setGapThreshold(2.147483647E9);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("complete for chart '{}', series {} in {}ms", new Object[]{((LineChartDefinition)this.definition).getTitle(), datasetIndex, (double)(System.nanoTime() - start) / 1000000.0});
        }
    }

    public static void setRelativeAxis(JFreeChart chart, long startTime) {
        if (chart != null) {
            RelativeDateFormat format = new RelativeDateFormat(startTime);
            format.setHourSuffix(":");
            format.setMinuteSuffix(":");
            format.setSecondSuffix("");
            DecimalFormat padded = new DecimalFormat("00");
            format.setMinuteFormatter((NumberFormat)padded);
            format.setSecondFormatter((NumberFormat)padded);
            XYPlot plot = chart.getXYPlot();
            ((DateAxis)plot.getDomainAxis()).setDateFormatOverride((DateFormat)format);
        }
    }

    public static void setAbsoluteAxis(JFreeChart chart) {
        XYPlot plot;
        if (chart != null && (plot = chart.getXYPlot()).getDomainAxis() instanceof DateAxis) {
            ((DateAxis)plot.getDomainAxis()).setDateFormatOverride(null);
        }
    }

    public static void setPercentYAxis(JFreeChart chart) {
        NumberAxis yAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        yAxis.setRange(0.0, 100.0);
    }
}

