/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.builder;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.gui.chart.TimeAndValueTooltipGenerator;
import com.ibm.nmon.gui.chart.builder.ChartBuilderPlugin;
import com.ibm.nmon.gui.chart.builder.LineChartBuilder;
import com.ibm.nmon.interval.Interval;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;

public final class LineChartBuilderPlugin
implements ChartBuilderPlugin {
    private final NMONVisualizerApp app;

    public LineChartBuilderPlugin(NMONVisualizerApp app) {
        this.app = app;
    }

    @Override
    public void configureChart(JFreeChart chart) {
        if (this.app.getBooleanProperty("chartRelativeTime")) {
            LineChartBuilder.setRelativeAxis(chart, this.app.getMinSystemTime());
        } else {
            LineChartBuilder.setAbsoluteAxis(chart);
        }
        DateAxis axis = (DateAxis)chart.getXYPlot().getDomainAxis();
        Interval current = this.app.getIntervalManager().getCurrentInterval();
        axis.setTimeZone(this.app.getDisplayTimeZone());
        if (chart.getXYPlot().getRenderer().getBaseToolTipGenerator().getClass() == TimeAndValueTooltipGenerator.class) {
            ((TimeAndValueTooltipGenerator)chart.getXYPlot().getRenderer().getBaseToolTipGenerator()).setTimeZone(this.app.getDisplayTimeZone());
        }
        if (Interval.DEFAULT.equals(current)) {
            if (this.app.getMinSystemTime() == 0L) {
                long now = System.currentTimeMillis();
                axis.setRange((double)(now - 43200000L), (double)(now + 43199500L));
            } else {
                long max;
                long min = this.app.getMinSystemTime();
                if (min == (max = this.app.getMaxSystemTime())) {
                    min -= 1000L;
                }
                axis.setRange((double)min, (double)max);
            }
        } else {
            axis.setRange((double)current.getStart(), (double)current.getEnd());
        }
    }
}

