/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.data;

import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.data.DatasetCallback;
import com.ibm.nmon.gui.chart.data.GraphData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DataTupleCategoryDataset
extends DefaultCategoryDataset
implements DataTupleDataset {
    private static final long serialVersionUID = -3658914756373575628L;
    private final Map<String, Map<String, DataTuple>> tuples;
    private final boolean intervals;
    private boolean categoriesHaveDifferentStats;
    private GraphData[] graphData;
    private DatasetCallback callback = new DatasetCallback(){

        @Override
        public int getDataCount() {
            return DataTupleCategoryDataset.this.getRowCount();
        }

        @Override
        public int getItemCount(int dataIdx) {
            return DataTupleCategoryDataset.this.getColumnCount();
        }

        @Override
        public double getValue(int dataIdx, int itemIdx) {
            return (Double)DataTupleCategoryDataset.this.getValue(dataIdx, itemIdx);
        }
    };

    public DataTupleCategoryDataset(boolean containsIntervals) {
        this.tuples = new HashMap<String, Map<String, DataTuple>>();
        this.intervals = containsIntervals;
        this.categoriesHaveDifferentStats = false;
    }

    @Override
    public void associateTuple(Comparable rowKey, Comparable columnKey, DataTuple tuple) {
        if (rowKey == null || columnKey == null || tuple == null) {
            return;
        }
        Map<String, DataTuple> columns = this.tuples.get(rowKey.toString());
        if (columns == null) {
            columns = new HashMap<String, DataTuple>(3);
            this.tuples.put(rowKey.toString(), columns);
        }
        columns.put(columnKey.toString(), tuple);
        this.graphData = null;
    }

    @Override
    public DataTuple getTuple(int row, int column) {
        if (this.intervals) {
            Map<String, DataTuple> columns = this.tuples.get(this.getRowKey(column).toString());
            if (columns == null) {
                return null;
            }
            return columns.get(this.getColumnKey(row).toString());
        }
        Map<String, DataTuple> columns = this.tuples.get(this.getRowKey(row).toString());
        if (columns == null) {
            return null;
        }
        return columns.get(this.getColumnKey(column).toString());
    }

    @Override
    public Iterable<DataTuple> getAllTuples() {
        HashSet<DataTuple> allTuples = new HashSet<DataTuple>();
        for (String key : this.tuples.keySet()) {
            allTuples.addAll(this.tuples.get(key).values());
        }
        return Collections.unmodifiableSet(allTuples);
    }

    @Override
    public double getAverage(int row) {
        this.calculateGraphData();
        return this.graphData[row].average;
    }

    @Override
    public double getMinimum(int row) {
        this.calculateGraphData();
        return this.graphData[row].minimum;
    }

    @Override
    public double getMaximum(int row) {
        this.calculateGraphData();
        return this.graphData[row].maximum;
    }

    @Override
    public double getMedian(int row) {
        this.calculateGraphData();
        return this.graphData[row].median;
    }

    @Override
    public double get95thPercentile(int row) {
        this.calculateGraphData();
        return this.graphData[row].median;
    }

    @Override
    public double get99thPercentile(int row) {
        this.calculateGraphData();
        return this.graphData[row].percentile95;
    }

    @Override
    public double getStandardDeviation(int row) {
        this.calculateGraphData();
        return this.graphData[row].standardDeviation;
    }

    @Override
    public double getSum(int row) {
        this.calculateGraphData();
        return this.graphData[row].sum;
    }

    @Override
    public int getCount(int row) {
        this.calculateGraphData();
        return this.graphData[row].count;
    }

    @Override
    public boolean containsTuple(DataTuple tuple) {
        for (Map<String, DataTuple> columns : this.tuples.values()) {
            if (!columns.containsValue(tuple)) continue;
            return true;
        }
        return false;
    }

    public DataTupleCategoryDataset merge(DataTupleCategoryDataset other) {
        DataTupleCategoryDataset toReturn = new DataTupleCategoryDataset(other.containsIntervals());
        toReturn.categoriesHaveDifferentStats = this.categoriesHaveDifferentStats | other.categoriesHaveDifferentStats;
        toReturn.tuples.putAll(this.tuples);
        toReturn.tuples.putAll(other.tuples);
        return toReturn;
    }

    private void calculateGraphData() {
        if (this.graphData != null) {
            return;
        }
        if (!this.intervals) {
            int size = this.getRowCount() * this.getColumnCount();
            this.graphData = new GraphData[size];
            for (int i = 0; i < size; ++i) {
                this.graphData[i] = new GraphData();
                this.graphData[i].minimum = Double.NaN;
                this.graphData[i].maximum = Double.NaN;
            }
        } else {
            this.graphData = GraphData.calculate(this.callback);
        }
    }

    public boolean containsIntervals() {
        return this.intervals;
    }

    public boolean categoriesHaveDifferentStats() {
        return this.categoriesHaveDifferentStats;
    }

    public void setCategoriesHaveDifferentStats(boolean categoriesHaveDifferentStats) {
        this.categoriesHaveDifferentStats = categoriesHaveDifferentStats;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            return this.tuples.equals(((DataTupleCategoryDataset)obj).tuples);
        }
        return false;
    }

    public int hashCode() {
        return this.tuples.hashCode();
    }
}

