/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.data;

import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.data.DatasetCallback;
import com.ibm.nmon.gui.chart.data.GraphData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;

public final class DataTupleHistogramDataset
extends HistogramDataset
implements DataTupleDataset {
    private static final long serialVersionUID = -5932939796158641508L;
    private final List<DataTuple> tuples;
    private GraphData[] graphData;
    private final DatasetCallback callback = new DatasetCallback(){

        @Override
        public int getDataCount() {
            return DataTupleHistogramDataset.this.getSeriesCount();
        }

        @Override
        public int getItemCount(int dataIdx) {
            return DataTupleHistogramDataset.this.getItemCount(dataIdx);
        }

        @Override
        public double getValue(int dataIdx, int itemIdx) {
            return DataTupleHistogramDataset.this.getYValue(dataIdx, itemIdx);
        }
    };

    public DataTupleHistogramDataset() {
        this.tuples = new ArrayList<DataTuple>();
    }

    public Number getY(int series, int item) {
        Number toReturn = super.getY(series, item);
        if (this.getType() == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((Double)toReturn * 100.0);
        }
        return toReturn;
    }

    @Override
    public void associateTuple(Comparable rowKey, Comparable columnKey, DataTuple tuple) {
        int idx = this.indexOf(rowKey);
        if (idx != -1) {
            this.tuples.add(idx, tuple);
            this.graphData = null;
        }
    }

    @Override
    public DataTuple getTuple(int row, int column) {
        return this.tuples.get(row);
    }

    @Override
    public Iterable<DataTuple> getAllTuples() {
        return Collections.unmodifiableList(this.tuples);
    }

    @Override
    public double getAverage(int row) {
        this.calculateGraphData();
        return this.graphData[row].average;
    }

    @Override
    public double getMinimum(int row) {
        this.calculateGraphData();
        return this.graphData[row].minimum;
    }

    @Override
    public double getMaximum(int row) {
        this.calculateGraphData();
        return this.graphData[row].maximum;
    }

    @Override
    public double getMedian(int row) {
        this.calculateGraphData();
        return this.graphData[row].median;
    }

    @Override
    public double get95thPercentile(int row) {
        this.calculateGraphData();
        return this.graphData[row].percentile95;
    }

    @Override
    public double get99thPercentile(int row) {
        this.calculateGraphData();
        return this.graphData[row].percentile99;
    }

    @Override
    public double getStandardDeviation(int row) {
        this.calculateGraphData();
        return this.graphData[row].standardDeviation;
    }

    @Override
    public double getSum(int row) {
        this.calculateGraphData();
        return this.graphData[row].sum;
    }

    @Override
    public int getCount(int row) {
        this.calculateGraphData();
        return this.graphData[row].count;
    }

    @Override
    public boolean containsTuple(DataTuple tuple) {
        return this.tuples.contains(tuple);
    }

    public DataTupleHistogramDataset merge(DataTupleHistogramDataset other) {
        DataTupleHistogramDataset toReturn = new DataTupleHistogramDataset();
        toReturn.tuples.addAll(this.tuples);
        toReturn.tuples.addAll(other.tuples);
        return toReturn;
    }

    private void calculateGraphData() {
        if (this.graphData != null) {
            return;
        }
        this.graphData = GraphData.calculate(this.callback);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            return this.tuples.equals(((DataTupleHistogramDataset)obj).tuples);
        }
        return false;
    }

    public int hashCode() {
        return this.tuples.hashCode();
    }
}

