/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.data;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.gui.chart.data.DatasetCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class GraphData {
    int count = 0;
    double sum = 0.0;
    double average = Double.NaN;
    double median = Double.NaN;
    double percentile95 = Double.NaN;
    double percentile99 = Double.NaN;
    double minimum = Double.MAX_VALUE;
    double maximum = Double.MIN_VALUE;
    double standardDeviation = Double.NaN;

    GraphData() {
    }

    static GraphData[] calculate(DatasetCallback callback) {
        int dataCount = callback.getDataCount();
        GraphData[] graphData = new GraphData[dataCount];
        for (int i = 0; i < dataCount; ++i) {
            GraphData data;
            graphData[i] = data = new GraphData();
            int itemCount = callback.getItemCount(i);
            ArrayList<Double> allValues = new ArrayList<Double>(itemCount);
            for (int j = 0; j < itemCount; ++j) {
                double value = callback.getValue(i, j);
                if (Double.isNaN(value)) continue;
                data.sum += value;
                if (value > data.maximum) {
                    data.maximum = value;
                }
                if (value < data.minimum) {
                    data.minimum = value;
                }
                allValues.add(value);
            }
            if (allValues.size() > 0) {
                data.count = allValues.size();
                data.average = data.sum / (double)data.count;
                Collections.sort(allValues);
                data.median = AnalysisRecord.calculatePercentile(0.5, allValues);
                data.percentile95 = AnalysisRecord.calculatePercentile(0.95, allValues);
                data.percentile99 = AnalysisRecord.calculatePercentile(0.99, allValues);
                double sumSqDiffs = 0.0;
                Iterator i$ = allValues.iterator();
                while (i$.hasNext()) {
                    double value = (Double)i$.next();
                    sumSqDiffs += Math.pow(value - data.average, 2.0);
                }
                data.standardDeviation = Math.sqrt(sumSqDiffs / (double)data.count);
                continue;
            }
            data.maximum = Double.NaN;
            data.minimum = Double.NaN;
        }
        return graphData;
    }
}

