/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.summary;

import com.ibm.nmon.gui.chart.summary.ChartSummaryPanel;
import com.ibm.nmon.gui.chart.summary.ChartSummaryTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

final class ChartSummaryMenu
extends MouseAdapter {
    private final ChartSummaryPanel summaryPanel;
    private final JPopupMenu menuForRows;
    private final JPopupMenu menuForNoRows;
    private final JPopupMenu menuForNoVisibilty;

    public ChartSummaryMenu(ChartSummaryPanel summaryTable) {
        this.summaryPanel = summaryTable;
        ActionListener selectColumns = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSummaryMenu.this.summaryPanel.displayTableColumnChooser();
            }
        };
        ActionListener showNone = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSummaryTableModel tableModel = ChartSummaryMenu.this.summaryPanel.getTableModel();
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    tableModel.setValueAt(false, i, 0);
                }
                ChartSummaryMenu.this.summaryPanel.repaint();
            }
        };
        ActionListener showAll = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSummaryTableModel tableModel = ChartSummaryMenu.this.summaryPanel.getTableModel();
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    tableModel.setValueAt(true, i, 0);
                }
                ChartSummaryMenu.this.summaryPanel.repaint();
            }
        };
        this.menuForRows = new JPopupMenu();
        this.menuForNoRows = new JPopupMenu();
        this.menuForNoVisibilty = new JPopupMenu();
        JMenuItem item = new JMenuItem("Show Selected Only");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                ChartSummaryTableModel tableModel = ChartSummaryMenu.this.summaryPanel.getTableModel();
                int[] selectedRows = ChartSummaryMenu.this.summaryPanel.getSummaryTable().getSelectedRows();
                for (i = 0; i < selectedRows.length; ++i) {
                    selectedRows[i] = ChartSummaryMenu.this.summaryPanel.getSummaryTable().convertRowIndexToModel(selectedRows[i]);
                }
                for (i = 0; i < tableModel.getRowCount(); ++i) {
                    boolean selected = false;
                    for (int j = 0; j < selectedRows.length; ++j) {
                        if (i != selectedRows[j]) continue;
                        tableModel.setValueAt(true, i, 0);
                        selected = true;
                        break;
                    }
                    if (selected) continue;
                    tableModel.setValueAt(false, i, 0);
                }
                ChartSummaryMenu.this.summaryPanel.repaint();
            }
        });
        this.menuForRows.add(item);
        item = new JMenuItem("Show None");
        item.addActionListener(showNone);
        this.menuForRows.add(item);
        item = new JMenuItem("Show None");
        item.addActionListener(showNone);
        this.menuForNoRows.add(item);
        item = new JMenuItem("Show All");
        item.addActionListener(showAll);
        this.menuForRows.add(item);
        item = new JMenuItem("Show All");
        item.addActionListener(showAll);
        this.menuForNoRows.add(item);
        this.menuForRows.addSeparator();
        this.menuForNoRows.addSeparator();
        item = new JMenuItem("Select Columns...");
        item.addActionListener(selectColumns);
        this.menuForRows.add(item);
        item = new JMenuItem("Select Columns...");
        item.addActionListener(selectColumns);
        this.menuForNoRows.add(item);
        item = new JMenuItem("Select Columns...");
        item.addActionListener(selectColumns);
        this.menuForNoVisibilty.add(item);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.summaryPanel.getTableModel().getEnabled("\u2713")) {
                int row = this.summaryPanel.getSummaryTable().rowAtPoint(e.getPoint());
                int[] selectedRows = this.summaryPanel.getSummaryTable().getSelectedRows();
                if (row < 0) {
                    if (selectedRows.length == 0) {
                        this.menuForNoRows.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        this.menuForRows.show(e.getComponent(), e.getX(), e.getY());
                    }
                } else if (selectedRows.length == 0) {
                    this.summaryPanel.getSummaryTable().changeSelection(row, 0, false, false);
                    this.menuForRows.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    this.menuForRows.show(e.getComponent(), e.getX(), e.getY());
                }
            } else {
                this.menuForNoVisibilty.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

