/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.summary;

import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.summary.ChartSummaryMenu;
import com.ibm.nmon.gui.chart.summary.ChartSummaryTableModel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.DoubleCellRenderer;
import com.ibm.nmon.gui.table.IntegerCellRenderer;
import com.ibm.nmon.gui.table.StringCellRenderer;
import com.ibm.nmon.gui.table.TableColumnChooser;
import com.ibm.nmon.gui.util.ScrollingTableFix;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public final class ChartSummaryPanel
extends JScrollPane
implements PropertyChangeListener {
    private static final long serialVersionUID = -7959432908033304478L;
    private final NMONVisualizerGui gui;
    private final JFrame parent;
    private final GUITable summaryTable;
    private final ChartSummaryTableModel tableModel;

    public ChartSummaryPanel(NMONVisualizerGui gui, JFrame parent, String[] defaultColumns) {
        this.gui = gui;
        this.parent = parent;
        this.tableModel = new ChartSummaryTableModel(gui, defaultColumns);
        this.tableModel.addPropertyChangeListener(this);
        this.summaryTable = this.createTable();
        this.setViewportView(this.summaryTable);
        this.getViewport().setBackground(Color.WHITE);
        this.addComponentListener(new ScrollingTableFix(this.summaryTable, this));
        this.setBorder(null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (enabled) {
                this.gui.addPropertyChangeListener("granularity", this.tableModel);
                this.tableModel.updateGranularityMax();
            } else {
                this.gui.removePropertyChangeListener("granularity", this.tableModel);
            }
            super.setEnabled(enabled);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chart".equals(evt.getPropertyName())) {
            if (evt.getNewValue() != null) {
                BaseChartPanel chartPanel = (BaseChartPanel)evt.getNewValue();
                DataTupleDataset dataset = chartPanel.getDataset();
                this.tableModel.setData(dataset);
            } else {
                this.tableModel.clear();
            }
        } else if ("rowVisible".equals(evt.getPropertyName())) {
            this.firePropertyChange("rowVisible", null, evt.getNewValue());
        }
    }

    private GUITable createTable() {
        GUITable table = new GUITable(this.gui, this.tableModel){
            private static final long serialVersionUID = 2380417479703405189L;

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.getColumnModel()){
                    private static final long serialVersionUID = -4028332367434358857L;

                    @Override
                    public String getToolTipText(MouseEvent event) {
                        super.getToolTipText(event);
                        int column = this.getTable().convertColumnIndexToModel(((DefaultTableColumnModel)this.getTable().getColumnModel()).getColumnIndexAtX(event.getX()));
                        return this.getColumnName(column);
                    }
                };
            }
        };
        table.addMouseListener(new ChartSummaryMenu(this));
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean[] selectedRows = new boolean[ChartSummaryPanel.this.summaryTable.getRowCount()];
                    ListSelectionModel model = (ListSelectionModel)e.getSource();
                    for (int i = model.getMinSelectionIndex(); i <= model.getMaxSelectionIndex(); ++i) {
                        if (!model.isSelectedIndex(i)) continue;
                        selectedRows[((ChartSummaryPanel)ChartSummaryPanel.this).summaryTable.convertRowIndexToModel((int)i)] = true;
                    }
                    ChartSummaryPanel.this.firePropertyChange("selectedRows", null, selectedRows);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(table.getTableHeader());
        table.getColumnModel().getColumn(0).setMaxWidth(25);
        table.setDefaultRenderer(Boolean.class, new CheckBoxCellRenderer());
        table.setDefaultRenderer(Double.class, new DoubleCellRenderer());
        table.setDefaultRenderer(Integer.class, new IntegerCellRenderer());
        table.setDefaultRenderer(String.class, new StringCellRenderer());
        return table;
    }

    public void clearSelection() {
        this.summaryTable.clearSelection();
    }

    public void selectRow(int datasetRow) {
        int row = this.summaryTable.convertRowIndexToView(datasetRow);
        this.summaryTable.getSelectionModel().setSelectionInterval(row, row);
        this.summaryTable.scrollRectToVisible(this.summaryTable.getCellRect(row, 0, false));
    }

    public void selectRow(int datasetRow, int datasetColumn) {
        int row = this.summaryTable.convertRowIndexToView(this.tableModel.getTableRow(datasetRow, datasetColumn));
        this.summaryTable.getSelectionModel().setSelectionInterval(row, row);
        this.summaryTable.scrollRectToVisible(this.summaryTable.getCellRect(row, 0, false));
    }

    public int getDatasetRow(int tableRow) {
        return this.tableModel.getDatasetRow(tableRow);
    }

    public int getDatasetColumn(int tableRow) {
        return this.tableModel.getDatasetColumn(tableRow);
    }

    public void displayTableColumnChooser() {
        new TableColumnChooser(this.gui, this.parent, this.tableModel);
    }

    GUITable getSummaryTable() {
        return this.summaryTable;
    }

    ChartSummaryTableModel getTableModel() {
        return this.tableModel;
    }

    private final class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 8963589765399665908L;

        private CheckBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected((Boolean)value);
            JLabel other = (JLabel)table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color bg = other.getBackground();
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(other.getForeground());
                this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            }
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            return this;
        }
    }
}

