/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.chart.summary;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.chart.data.DataTupleCategoryDataset;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.gui.chart.data.DataTupleHistogramDataset;
import com.ibm.nmon.gui.chart.data.DataTupleXYDataset;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ChoosableColumnTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class ChartSummaryTableModel
extends ChoosableColumnTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4224937019632087892L;
    static final String VISIBLE = "\u2713";
    private static final String[] COLUMN_NAMES = new String[]{"\u2713", "Hostname", "Data Type", "Metric", "Series Name", Statistic.MINIMUM.toString(), Statistic.AVERAGE.toString(), Statistic.MAXIMUM.toString(), Statistic.STD_DEV.toString(), null, Statistic.MEDIAN.toString(), Statistic.PERCENTILE_95.toString(), Statistic.PERCENTILE_99.toString(), Statistic.SUM.toString(), Statistic.COUNT.toString(), "Graph " + Statistic.MINIMUM.toString(), "Graph " + Statistic.AVERAGE.toString(), "Graph " + Statistic.MAXIMUM.toString(), "Graph " + Statistic.STD_DEV.toString(), "Graph " + Statistic.MEDIAN.toString(), "Graph " + Statistic.PERCENTILE_95.toString(), "Graph " + Statistic.PERCENTILE_99.toString(), "Graph " + Statistic.SUM.toString(), "Graph " + Statistic.COUNT.toString()};
    private static final DataTuple NULL_TUPLE = new DataTuple(new SystemDataSet("N/A"), new DataType("N/A", "N/A", "N/A"), "N/A");
    private static final AnalysisRecord NULL_ANALYSIS = new AnalysisRecord(NULL_TUPLE.getDataSet());
    private final NMONVisualizerGui gui;
    private boolean[] defaultColumns;
    private DataTupleDataset dataset;
    private boolean[] rowVisible;
    private final Map<Integer, boolean[]> rowVisibleCache;
    private PropertyChangeSupport propertyChangeSupport;

    public ChartSummaryTableModel(NMONVisualizerGui gui, String ... defaultColumnNames) {
        this.gui = gui;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        ChartSummaryTableModel.COLUMN_NAMES[9] = Statistic.GRANULARITY_MAXIMUM.getName(gui.getGranularity());
        this.buildColumnNameMap();
        if (defaultColumnNames == null) {
            defaultColumnNames = new String[]{VISIBLE, "Data Type", "Metric", "Minimum", "Average", "Maximum", "Std Dev"};
        }
        this.defaultColumns = new boolean[COLUMN_NAMES.length];
        Arrays.fill(this.defaultColumns, false);
        this.defaultColumns[0] = true;
        for (String columnName : defaultColumnNames) {
            int idx = this.getColumnIndex(columnName);
            if (idx != -1) {
                this.defaultColumns[idx] = true;
                continue;
            }
            this.logger.warn("ignoring non-existent column '{}' for defaults", (Object)columnName);
        }
        this.enabledColumns = new BitSet(COLUMN_NAMES.length);
        for (int i = 0; i < this.defaultColumns.length; ++i) {
            this.enabledColumns.set(i, this.defaultColumns[i]);
        }
        this.dataset = null;
        this.rowVisibleCache = new HashMap<Integer, boolean[]>();
    }

    @Override
    public int getRowCount() {
        if (this.dataset == null) {
            return 0;
        }
        if (this.dataset instanceof DataTupleCategoryDataset) {
            DataTupleCategoryDataset d = (DataTupleCategoryDataset)this.dataset;
            if (d.containsIntervals()) {
                return d.getRowCount();
            }
            if (d.categoriesHaveDifferentStats()) {
                return d.getColumnCount();
            }
            return d.getRowCount() * d.getColumnCount();
        }
        if (this.dataset instanceof DataTupleXYDataset) {
            return ((DataTupleXYDataset)this.dataset).getSeriesCount();
        }
        if (this.dataset instanceof DataTupleHistogramDataset) {
            return ((DataTupleHistogramDataset)this.dataset).getSeriesCount();
        }
        return 0;
    }

    @Override
    public String[] getAllColumns() {
        return COLUMN_NAMES;
    }

    @Override
    public boolean getDefaultColumnState(int column) {
        return this.defaultColumns[column];
    }

    @Override
    public boolean canDisableColumn(int column) {
        return column != 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0 && this.enabledColumns.get(0);
    }

    @Override
    protected Class<?> getEnabledColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex < 5) {
            return String.class;
        }
        if (columnIndex == 14) {
            return Integer.class;
        }
        if (columnIndex == 23) {
            return Integer.class;
        }
        return Double.class;
    }

    @Override
    protected String getEnabledColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    protected Object getEnabledValueAt(int row, int column) {
        DataTupleDataset d;
        DataTuple tuple = null;
        String seriesName = "";
        boolean graphDataOnly = false;
        if (this.dataset instanceof DataTupleCategoryDataset) {
            d = (DataTupleCategoryDataset)this.dataset;
            int columnCount = ((DataTupleCategoryDataset)d).containsIntervals() ? d.getRowCount() : d.getColumnCount();
            int datasetRow = row / columnCount;
            int datasetColumn = row % columnCount;
            tuple = ((DataTupleCategoryDataset)d).getTuple(datasetRow, datasetColumn);
            seriesName = ((DataTupleCategoryDataset)d).containsIntervals() ? d.getRowKey(datasetColumn).toString() : (((DataTupleCategoryDataset)d).categoriesHaveDifferentStats() ? d.getColumnKey(datasetColumn).toString() : d.getColumnKey(datasetColumn).toString() + " - " + d.getRowKey(datasetRow).toString());
            graphDataOnly = ((DataTupleCategoryDataset)d).containsIntervals();
        } else if (this.dataset instanceof DataTupleXYDataset) {
            d = (DataTupleXYDataset)this.dataset;
            tuple = ((DataTupleXYDataset)d).getTuple(row, -1);
            seriesName = d.getSeriesKey(row).toString();
        } else if (this.dataset instanceof DataTupleHistogramDataset) {
            d = (DataTupleHistogramDataset)this.dataset;
            tuple = ((DataTupleHistogramDataset)d).getTuple(row, -1);
            seriesName = d.getSeriesKey(row).toString();
        }
        AnalysisRecord analysis = null;
        if (tuple == null) {
            tuple = NULL_TUPLE;
            analysis = NULL_ANALYSIS;
        } else if (!graphDataOnly) {
            analysis = this.gui.getAnalysis(tuple.getDataSet());
        }
        switch (column) {
            case 0: {
                return this.rowVisible[row];
            }
            case 1: {
                return tuple.getDataSet().getHostname();
            }
            case 2: {
                return tuple.getDataType().toString();
            }
            case 3: {
                return tuple.getField();
            }
            case 4: {
                return seriesName;
            }
            case 5: {
                return graphDataOnly ? this.dataset.getMinimum(row) : analysis.getMinimum(tuple.getDataType(), tuple.getField());
            }
            case 6: {
                return graphDataOnly ? this.dataset.getAverage(row) : analysis.getAverage(tuple.getDataType(), tuple.getField());
            }
            case 7: {
                return graphDataOnly ? this.dataset.getMaximum(row) : analysis.getMaximum(tuple.getDataType(), tuple.getField());
            }
            case 8: {
                return graphDataOnly ? this.dataset.getStandardDeviation(row) : analysis.getStandardDeviation(tuple.getDataType(), tuple.getField());
            }
            case 9: {
                return graphDataOnly ? Double.NaN : analysis.getGranularityMaximum(tuple.getDataType(), tuple.getField());
            }
            case 10: {
                return graphDataOnly ? this.dataset.getMedian(row) : analysis.getMedian(tuple.getDataType(), tuple.getField());
            }
            case 11: {
                return graphDataOnly ? this.dataset.get95thPercentile(row) : analysis.get95thPercentile(tuple.getDataType(), tuple.getField());
            }
            case 12: {
                return graphDataOnly ? this.dataset.get99thPercentile(row) : analysis.get99thPercentile(tuple.getDataType(), tuple.getField());
            }
            case 13: {
                return graphDataOnly ? this.dataset.getSum(row) : analysis.getSum(tuple.getDataType(), tuple.getField());
            }
            case 14: {
                return graphDataOnly ? this.dataset.getCount(row) : analysis.getCount(tuple.getDataType(), tuple.getField());
            }
            case 15: {
                return this.dataset.getMinimum(row);
            }
            case 16: {
                return this.dataset.getAverage(row);
            }
            case 17: {
                return this.dataset.getMaximum(row);
            }
            case 18: {
                return this.dataset.getStandardDeviation(row);
            }
            case 19: {
                return this.dataset.getMedian(row);
            }
            case 20: {
                return this.dataset.get95thPercentile(row);
            }
            case 21: {
                return this.dataset.get99thPercentile(row);
            }
            case 22: {
                return this.dataset.getSum(row);
            }
            case 23: {
                return this.dataset.getCount(row);
            }
        }
        throw new ArrayIndexOutOfBoundsException(column);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        boolean visible = (Boolean)value;
        if (this.rowVisible[rowIndex] != visible) {
            this.rowVisible[rowIndex] = visible;
            Object[] values = new Object[]{this.getDatasetRow(rowIndex), this.getDatasetColumn(columnIndex), visible};
            this.propertyChangeSupport.firePropertyChange("rowVisible", null, values);
        }
    }

    int getDatasetRow(int tableRow) {
        if (this.dataset instanceof DataTupleCategoryDataset) {
            DataTupleCategoryDataset d = (DataTupleCategoryDataset)this.dataset;
            if (d.containsIntervals()) {
                return tableRow;
            }
            int columnCount = d.getColumnCount();
            return tableRow / columnCount;
        }
        return tableRow;
    }

    int getDatasetColumn(int tableRow) {
        if (this.dataset instanceof DataTupleCategoryDataset) {
            DataTupleCategoryDataset d = (DataTupleCategoryDataset)this.dataset;
            if (d.containsIntervals()) {
                return -1;
            }
            int columnCount = d.getColumnCount();
            if (columnCount == 0) {
                return -1;
            }
            return tableRow % columnCount;
        }
        return -1;
    }

    int getTableRow(int datasetRow, int datasetColumn) {
        if (this.dataset instanceof DataTupleCategoryDataset) {
            DataTupleCategoryDataset d = (DataTupleCategoryDataset)this.dataset;
            if (d.containsIntervals()) {
                return datasetRow;
            }
            int columnCount = d.getColumnCount();
            return datasetRow * columnCount + datasetColumn;
        }
        return datasetRow;
    }

    void setData(DataTupleDataset dataset) {
        DataTupleDataset d;
        if (this.dataset == dataset) {
            return;
        }
        this.dataset = dataset;
        if (dataset == null) {
            this.fireTableDataChanged();
            return;
        }
        int rowCount = this.getRowCount();
        int hashCode = 1;
        for (DataTuple t : dataset.getAllTuples()) {
            Process process;
            int typeHash = t.getDataType().hashCode();
            if (t.getDataType().getClass() == ProcessDataType.class && (process = ((ProcessDataType)t.getDataType()).getProcess()).getId() != -1) {
                typeHash = process.getName().hashCode();
            }
            hashCode = hashCode * 11 + typeHash * 31 + t.getField().hashCode() * 57;
        }
        this.rowVisible = this.rowVisibleCache.get(hashCode);
        if (this.rowVisible == null) {
            this.rowVisible = new boolean[rowCount];
            Arrays.fill(this.rowVisible, true);
            this.rowVisibleCache.put(hashCode, this.rowVisible);
        }
        if (dataset instanceof DataTupleCategoryDataset) {
            d = (DataTupleCategoryDataset)dataset;
            if (!((DataTupleCategoryDataset)d).containsIntervals()) {
                this.setEnabled(VISIBLE, false);
            } else {
                this.setEnabled(VISIBLE, true);
            }
        } else if (dataset instanceof DataTupleXYDataset) {
            d = (DataTupleXYDataset)dataset;
            if (((DataTupleXYDataset)d).isStacked()) {
                this.setEnabled(VISIBLE, false);
            } else if (d.getSeriesCount() > 1) {
                this.setEnabled(VISIBLE, true);
            } else {
                this.setEnabled(VISIBLE, false);
            }
        } else if (dataset instanceof DataTupleHistogramDataset) {
            d = (DataTupleHistogramDataset)dataset;
            if (d.getSeriesCount() > 1) {
                this.setEnabled(VISIBLE, true);
            } else {
                this.setEnabled(VISIBLE, false);
            }
        }
        if (this.logger.isTraceEnabled()) {
            int i;
            Cloneable series;
            if (dataset instanceof DataTupleXYDataset) {
                d = (DataTupleXYDataset)dataset;
                series = new ArrayList();
                for (i = 0; i < d.getSeriesCount(); ++i) {
                    series.add(d.getSeriesKey(i).toString());
                }
                this.logger.trace("set data for XY chart with {}", series);
            } else if (dataset instanceof DataTupleXYDataset) {
                d = (DataTupleCategoryDataset)dataset;
                series = new HashMap();
                for (i = 0; i < d.getColumnCount(); ++i) {
                    ArrayList<String> categories = new ArrayList<String>(3);
                    series.put(d.getColumnKey(i).toString(), categories);
                    for (int j = 0; j < d.getRowCount(); ++j) {
                        categories.add(d.getRowKey(j).toString());
                    }
                }
                this.logger.trace("set data for category chart with {}", (Object)series);
            } else if (dataset instanceof DataTupleHistogramDataset) {
                d = (DataTupleHistogramDataset)dataset;
                series = new ArrayList();
                for (i = 0; i < d.getSeriesCount(); ++i) {
                    series.add(d.getSeriesKey(i).toString());
                }
                this.logger.trace("set data for histogram chart with {}", (Object)series);
            }
        }
        this.fireTableDataChanged();
        Object[] values = new Object[3];
        values[1] = this.getDatasetColumn(0);
        for (int i = 0; i < rowCount; ++i) {
            values[0] = this.getDatasetRow(i);
            values[2] = this.rowVisible[i];
            this.propertyChangeSupport.firePropertyChange("rowVisible", null, values);
        }
    }

    void clear() {
        if (this.dataset != null) {
            this.dataset = null;
            this.fireTableDataChanged();
        }
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("granularity".equals(evt.getPropertyName())) {
            this.updateGranularityMax();
        }
    }

    void updateGranularityMax() {
        ChartSummaryTableModel.COLUMN_NAMES[9] = Statistic.GRANULARITY_MAXIMUM.getName(this.gui.getGranularity());
        this.buildColumnNameMap();
        if (this.enabledColumns.get(9)) {
            this.fireTableStructureChanged();
        }
    }
}

