/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.data;

import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.HostnameComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class MergeDataSetDialog
extends GUIDialog {
    private static final long serialVersionUID = 8152894318175367260L;
    private JComboBox<String> hostnames;
    private JButton merge;
    private SystemDataSet toMerge;

    public MergeDataSetDialog(NMONVisualizerGui gui, SystemDataSet toMerge) {
        super(gui, gui.getMainFrame(), "Merge With?");
        this.setResizable(false);
        this.setModal(true);
        this.toMerge = toMerge;
        JLabel hostname = new JLabel(toMerge.getHostname());
        hostname.setFont(Styles.TITLE);
        hostname.setHorizontalAlignment(0);
        hostname.setBorder(Styles.TITLE_BORDER);
        JLabel mergeHostLabel = new JLabel("Merge Into:");
        mergeHostLabel.setFont(Styles.LABEL);
        this.hostnames = new JComboBox<String>(new HostnameComboBoxModel(gui));
        this.hostnames.setEditable(false);
        this.merge = new JButton("Merge");
        this.merge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostname = (String)MergeDataSetDialog.this.hostnames.getSelectedItem();
                if ("".equals(hostname)) {
                    JOptionPane.showMessageDialog(MergeDataSetDialog.this, "Please select a valid hostname", "Invalid hostname", 0);
                } else if (MergeDataSetDialog.this.toMerge.getHostname().equals(hostname)) {
                    MergeDataSetDialog.this.dispose();
                } else {
                    for (SystemDataSet data : MergeDataSetDialog.this.gui.getDataSets()) {
                        if (!data.getHostname().equals(hostname)) continue;
                        data.addData(MergeDataSetDialog.this.toMerge);
                        MergeDataSetDialog.this.gui.removeDataSet(MergeDataSetDialog.this.toMerge);
                        MergeDataSetDialog.this.gui.updateDataSet(data);
                        MergeDataSetDialog.this.dispose();
                        return;
                    }
                }
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeDataSetDialog.this.dispose();
            }
        });
        JPanel center = new JPanel();
        center.setBorder(Styles.CONTENT_BORDER);
        center.add(mergeHostLabel);
        center.add(this.hostnames);
        JPanel temp = new JPanel();
        temp.add(this.merge);
        temp.add(cancel);
        this.add((Component)hostname, "First");
        this.add((Component)center, "Center");
        this.add((Component)temp, "Last");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.merge);
            this.hostnames.setSelectedItem(this.hostnames.getItemAt(0));
            this.hostnames.requestFocus();
        }
        super.setVisible(b);
    }
}

