/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.dnd;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataTuple;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.gui.dnd.DataTransferable;
import com.ibm.nmon.gui.file.ParserRunner;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.tree.TreePathParser;
import com.ibm.nmon.util.FileHelper;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -2072907261684848635L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeTransferHandler.class);
    private final TreeTransferPathParser pathParser;
    private final NMONVisualizerGui gui;

    public TreeTransferHandler(NMONVisualizerGui gui) {
        this.pathParser = new TreeTransferPathParser(gui);
        this.gui = gui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!c.getClass().equals(JTree.class)) {
            return null;
        }
        TreePath[] paths = ((JTree)c).getSelectionPaths();
        if (paths.length != 0) {
            try {
                for (TreePath path : paths) {
                    this.pathParser.parse(path);
                }
                DataTransferable dataTransferable = this.pathParser.getTransferable();
                return dataTransferable;
            }
            finally {
                this.pathParser.clearTransferable();
            }
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] flavors;
        for (DataFlavor flavor : flavors = support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            ArrayList<String> toParse = new ArrayList<String>(files.size());
            FileHelper.recurseDirectories(files, (FileFilter)CombinedFileFilter.getInstance(false), toParse);
            new Thread((Runnable)new ParserRunner(this.gui, toParse, this.gui.getDisplayTimeZone()), this.getClass().getName() + " Parser").start();
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("cannot import data", (Throwable)e);
            return false;
        }
    }

    private static final class TreeTransferPathParser
    extends TreePathParser {
        private NMONVisualizerGui gui;
        private DataTransferable transferable;

        public TreeTransferPathParser(NMONVisualizerGui gui) {
            this.gui = gui;
        }

        @Override
        protected void onTypePath(DataSet dataSet, DataType type) {
            if (this.transferable == null) {
                this.transferable = new DataTransferable();
            }
            this.matchByCommandLine(dataSet, type, null);
        }

        @Override
        protected void onFieldPath(DataSet dataSet, DataType type, String field) {
            if (this.transferable == null) {
                this.transferable = new DataTransferable();
            }
            this.matchByCommandLine(dataSet, type, field);
        }

        public DataTransferable getTransferable() {
            return this.transferable;
        }

        public void clearTransferable() {
            this.transferable = null;
        }

        private void matchByCommandLine(DataSet dataSet, DataType type, String field) {
            if (type instanceof ProcessDataType) {
                String command = ((ProcessDataType)type).getProcess().getCommandLine();
                for (DataSet dataSet2 : this.gui.getDataSets()) {
                    if (!(dataSet2 instanceof ProcessDataSet)) continue;
                    ProcessDataSet processData = (ProcessDataSet)dataSet2;
                    for (Process process : processData.getProcesses()) {
                        if (!process.getCommandLine().equals(command)) continue;
                        this.transferable.addTuple(new DataTuple(processData, processData.getType(process), field));
                    }
                }
            } else {
                this.transferable.addTuple(new DataTuple(dataSet, type, field));
            }
        }
    }
}

