/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.analysis.AnalysisSet;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class AnalysisSetFileChooser
extends GUIFileChooser {
    private static final long serialVersionUID = 4581059821787454370L;
    private final AnalysisSet analysis;

    public AnalysisSetFileChooser(NMONVisualizerGui gui, AnalysisSet analysis) {
        super(gui, "Select Table Definition File", "analysis.properties");
        this.analysis = analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.showDialog(this.gui.getMainFrame(), "Save") == 0) {
            int result;
            File analysisFile = this.getSelectedFile();
            if (analysisFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + analysisFile.getName() + "' already exists.\nDo you want to overwrite it?", "Overwrite?", 2, 3)) != 0) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(analysisFile);
                for (String key : this.analysis.getKeys()) {
                    DataType type = this.analysis.getType(key);
                    if (type instanceof ProcessDataType) {
                        writer.write(key);
                        writer.write(58);
                        writer.write(((ProcessDataType)type).getProcess().getCommandLine());
                        writer.write(10);
                        continue;
                    }
                    writer.write(key);
                    writer.write(10);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.showDialog(this.gui.getMainFrame(), "Load") == 0) {
            int result;
            File analysisFile = this.getSelectedFile();
            if (!analysisFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + analysisFile.getName() + "' is not a valid file", "Invalid File", 2, 0)) != 0) {
                return;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(analysisFile));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int idx = line.indexOf(58);
                    if (idx == -1) continue;
                    String typeId = line.substring(0, idx);
                    String field = line.substring(idx + 1);
                    String command = null;
                    if ((idx = line.indexOf(58, idx + 1)) != -1) {
                        field = line.substring(typeId.length() + 1, idx);
                        command = line.substring(idx + 1);
                    }
                    for (DataSet dataSet : this.gui.getDataSets()) {
                        if (command == null) {
                            DataType type = dataSet.getType(typeId);
                            if (type == null || !type.hasField(field)) continue;
                            this.analysis.addData(type, field);
                            continue;
                        }
                        if (!(dataSet instanceof ProcessDataSet)) continue;
                        ProcessDataSet processData = (ProcessDataSet)dataSet;
                        for (Process process : processData.getProcesses()) {
                            if (!process.getCommandLine().equals(command)) continue;
                            this.analysis.addData(processData.getType(process), field);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

