/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.util.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.swing.JOptionPane;

public final class CSVFileChooser
extends GUIFileChooser {
    private static final long serialVersionUID = 6573073002190791008L;
    private final DataSet data;
    private final DataType type;
    private final List<String> fields;

    public CSVFileChooser(NMONVisualizerGui gui, DataSet data, DataType type, List<String> fields) {
        super(gui, "Select CSV Save Location", CSVFileChooser.getFileName(data, type, fields));
        this.data = data;
        this.type = type;
        this.fields = fields;
    }

    private static String getFileName(DataSet data, DataType type, List<String> fields) {
        String typeName = "";
        if (type != null) {
            typeName = '_' + type.toString();
        }
        String fieldName = "";
        if (fields != null && fields.size() == 1) {
            fieldName = '-' + fields.get(0);
        }
        return data.getHostname() + typeName + fieldName + ".csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCSV() {
        if (this.showDialog(this.gui.getMainFrame(), "Save") == 0) {
            int result;
            File csvFile = this.getSelectedFile();
            if (csvFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + csvFile.getName() + "' already exists.\nDo you want to overwrite it?", "Overwrite?", 2, 3)) != 0) {
                return;
            }
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(csvFile));
                if (this.type == null) {
                    CSVWriter.write(this.data, this.gui.getIntervalManager().getCurrentInterval(), writer);
                } else {
                    CSVWriter.write(this.data, this.type, this.fields, this.gui.getIntervalManager().getCurrentInterval(), (Writer)writer);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

