/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.file.SwingAndIOFileFilter;
import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.file.ParserRunner;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.TimeZoneComboBox;
import com.ibm.nmon.util.FileHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public final class FileLoadAction
implements ActionListener {
    private final JFileChooser chooser;
    private final NMONVisualizerGui gui;
    private final TimeZoneComboBox timeZones;

    public FileLoadAction(NMONVisualizerGui gui) {
        this.gui = gui;
        String directory = gui.getPreferences().get("lastDirectory", null);
        this.chooser = new JFileChooser(directory);
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.setDialogTitle("Select Files to Parse");
        for (SwingAndIOFileFilter filter : CombinedFileFilter.getInstance(true).getFilters()) {
            this.chooser.addChoosableFileFilter(filter);
        }
        this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
        this.timeZones = new TimeZoneComboBox(gui.getDisplayTimeZone());
        GUIFileChooser.addComponentToChooser(this.chooser, "Time Zone:", this.timeZones);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.chooser.showDialog(this.gui.getMainFrame(), "Parse") != 0) {
            return;
        }
        File[] selectedFiles = this.chooser.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return;
        }
        this.gui.getPreferences().put("lastDirectory", selectedFiles[0].getParentFile().getAbsolutePath());
        ArrayList<String> toParse = new ArrayList<String>(selectedFiles.length);
        FileFilter filter = null;
        filter = this.chooser.getFileFilter() == this.chooser.getAcceptAllFileFilter() ? CombinedFileFilter.getInstance(false) : ((SwingAndIOFileFilter)this.chooser.getFileFilter()).getFilter();
        FileHelper.recurseDirectories(selectedFiles, filter, toParse);
        if (!toParse.isEmpty()) {
            new Thread((Runnable)new ParserRunner(this.gui, toParse, this.timeZones.getSelectedTimeZone()), this.getClass().getName() + " Parser").start();
        }
    }
}

