/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GUIFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 3483905864541979923L;
    protected final NMONVisualizerGui gui;
    private String defaultFileName;

    public GUIFileChooser(NMONVisualizerGui gui, String title) {
        this(gui, title, null);
    }

    public GUIFileChooser(NMONVisualizerGui gui, String title, String filename) {
        this.gui = gui;
        this.defaultFileName = filename;
        this.setDialogTitle(title);
        this.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(0);
        String directory = gui.getPreferences().get("lastSaveDirectory", null);
        if (this.defaultFileName != null) {
            this.setSelectedFile(new File(directory, this.defaultFileName));
        } else if (directory != null) {
            this.setCurrentDirectory(new File(directory));
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        int toReturn = super.showDialog(parent, approveButtonText);
        this.saveLastSaveLocation();
        return toReturn;
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        int toReturn = super.showOpenDialog(parent);
        this.saveLastSaveLocation();
        return toReturn;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        int toReturn = super.showSaveDialog(parent);
        this.saveLastSaveLocation();
        return toReturn;
    }

    private final void saveLastSaveLocation() {
        if (this.getSelectedFile() != null) {
            File parent = this.getSelectedFile();
            if (!parent.isDirectory()) {
                parent = parent.getParentFile();
            }
            if (parent != null) {
                this.gui.getPreferences().put("lastSaveDirectory", parent.getAbsolutePath());
            }
        }
    }

    protected static void addComponentToChooser(JFileChooser chooser, String toLabel, JComponent toAdd) {
        JPanel bottom = (JPanel)chooser.getComponent(chooser.getComponentCount() - 1);
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 2));
        if (toLabel != null) {
            JPanel filterPanel = (JPanel)bottom.getComponent(bottom.getComponentCount() - 2);
            JLabel filterLabel = (JLabel)filterPanel.getComponent(filterPanel.getComponentCount() - 2);
            JLabel label = new JLabel(toLabel);
            label.setFont(filterLabel.getFont());
            label.setBorder(filterLabel.getBorder());
            label.setPreferredSize(filterLabel.getPreferredSize());
            newPanel.add(label);
        }
        newPanel.add(toAdd);
        bottom.add((Component)newPanel, bottom.getComponentCount() - 1);
    }
}

