/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.gui.file.GUIFileChooser;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalFileChooser
extends GUIFileChooser {
    private static final long serialVersionUID = -7932619182874416212L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IntervalFileChooser.class);
    private JCheckBox useRelativeTime = new JCheckBox();

    public IntervalFileChooser(NMONVisualizerGui gui) {
        super(gui, "Select Interval File", "intervals.properties");
        this.useRelativeTime.setText("Relative Time?");
        this.useRelativeTime.setHorizontalTextPosition(2);
        this.useRelativeTime.setHorizontalAlignment(11);
        this.useRelativeTime.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        IntervalFileChooser.addComponentToChooser(this, null, this.useRelativeTime);
    }

    public void save() {
        if (this.showDialog(this.gui.getMainFrame(), "Save") == 0) {
            int result;
            File intervalFile = this.getSelectedFile();
            if (intervalFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + intervalFile.getName() + "' already exists.\nDo you want to overwrite it?", "Overwrite?", 2, 3)) != 0) {
                return;
            }
            try {
                long offset = 0L;
                if (this.useRelativeTime.isSelected()) {
                    offset = this.gui.getMinSystemTime();
                }
                this.gui.getIntervalManager().saveToFile(intervalFile, offset);
            }
            catch (IOException ioe) {
                LOGGER.error("could not load interval file '{}'", (Object)intervalFile.getAbsolutePath(), (Object)ioe);
            }
        }
    }

    public void load() {
        if (this.showDialog(this.gui.getMainFrame(), "Load") == 0) {
            int result;
            File intervalFile = this.getSelectedFile();
            if (!intervalFile.exists() && (result = JOptionPane.showConfirmDialog(this.gui.getMainFrame(), "File '" + intervalFile.getName() + "' is not a valid file", "Invalid File", 2, 0)) != 0) {
                return;
            }
            try {
                long offset = 0L;
                if (this.useRelativeTime.isSelected()) {
                    offset = this.gui.getMinSystemTime();
                }
                this.gui.getIntervalManager().loadFromFile(intervalFile, offset);
            }
            catch (IOException ioe) {
                LOGGER.error("could not save interval file '{}'", (Object)intervalFile.getAbsolutePath(), (Object)ioe);
            }
        }
    }
}

