/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ReadOnlyTableModel;
import com.ibm.nmon.gui.util.LogViewerDialog;
import com.ibm.nmon.gui.util.ScrollingTableFix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class ParserErrorDialog
extends GUIDialog {
    private static final long serialVersionUID = -9140024700542269099L;
    private final Map<String, String> errors;
    private final JSplitPane splitPane;
    private final GUITable errorList;
    private final JTextArea errorText;
    private final JButton ok;

    public ParserErrorDialog(NMONVisualizerGui gui, Map<String, String> fileErrors) {
        super(gui, gui.getMainFrame(), "Parsing Errors");
        this.setModal(true);
        this.setIconImage(LogViewerDialog.LOG_ICON.getImage());
        this.errors = fileErrors;
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(Styles.LOWER_LINE_BORDER);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParserErrorDialog.this.dispose();
            }
        });
        JButton copy = new JButton("Copy");
        copy.setIcon(Styles.COPY_ICON);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReadOnlyTableModel model = (ReadOnlyTableModel)ParserErrorDialog.this.errorList.getModel();
                String filename = (String)model.getValueAt(ParserErrorDialog.this.errorList.getSelectedRow(), 0);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(filename + ':' + '\n' + ParserErrorDialog.this.errorText.getText()), null);
            }
        });
        JButton copyAll = new JButton("Copy All");
        copyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder allErrors = new StringBuilder(ParserErrorDialog.this.errors.size() * 256);
                ReadOnlyTableModel model = (ReadOnlyTableModel)ParserErrorDialog.this.errorList.getModel();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    if (i != 0) {
                        allErrors.append('\n');
                    }
                    String filename = (String)model.getValueAt(i, 0);
                    allErrors.append(filename);
                    allErrors.append(':');
                    allErrors.append('\n');
                    allErrors.append((String)ParserErrorDialog.this.errors.get(filename));
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(allErrors.toString()), null);
            }
        });
        this.errorList = new GUITable(gui, new ReadOnlyTableModel());
        this.errorList.setSelectionMode(0);
        this.errorList.setTableHeader(null);
        this.errorList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ParserErrorDialog.this.dispose();
                    e.consume();
                }
            }
        });
        ((ReadOnlyTableModel)this.errorList.getModel()).addColumn("");
        for (String filename : this.errors.keySet()) {
            ((ReadOnlyTableModel)this.errorList.getModel()).addRow(new Object[]{filename});
        }
        this.errorText = new JTextArea();
        this.errorText.setColumns(75);
        this.errorText.setRows(15);
        this.errorText.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.errorText.setEditable(false);
        ((DefaultListSelectionModel)this.errorList.getSelectionModel()).addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    String filename = (String)ParserErrorDialog.this.errorList.getModel().getValueAt(ParserErrorDialog.this.errorList.getSelectedRow(), 0);
                    ParserErrorDialog.this.errorText.setText((String)ParserErrorDialog.this.errors.get(filename));
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.errorList);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setBorder(null);
        scroller.addComponentListener(new ScrollingTableFix(this.errorList, scroller));
        scroller.setColumnHeaderView(null);
        this.splitPane.setTopComponent(scroller);
        scroller = new JScrollPane(this.errorText);
        scroller.setBorder(null);
        this.splitPane.setBottomComponent(scroller);
        this.add((Component)this.splitPane, "Center");
        JPanel footer = new JPanel(new BorderLayout());
        JPanel temp = new JPanel();
        temp.add(this.ok);
        footer.add((Component)temp, "After");
        temp = new JPanel();
        temp.add(copy);
        temp.add(copyAll);
        footer.add((Component)temp, "Before");
        this.add((Component)footer, "Last");
        this.setPreferredSize(new Dimension((int)((double)gui.getMainFrame().getWidth() * 0.75), (int)((double)gui.getMainFrame().getHeight() * 0.5)));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ParserErrorDialog.this.splitPane.setDividerLocation(0.25);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.ok);
            this.errorList.getSelectionModel().setSelectionInterval(0, 0);
        }
        super.setVisible(b);
    }
}

