/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.file;

import com.ibm.nmon.gui.file.ParserErrorDialog;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.util.ItemProgressDialog;
import com.ibm.nmon.util.ParserLog;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.SwingUtilities;

public final class ParserRunner
implements Runnable {
    private final NMONVisualizerGui gui;
    private final List<String> toParse;
    private final TimeZone timeZone;
    private final ItemProgressDialog progress;
    private final Map<String, String> errors;

    public ParserRunner(NMONVisualizerGui gui, List<String> toParse, TimeZone timeZone) {
        this.gui = gui;
        this.toParse = toParse;
        this.timeZone = timeZone;
        this.progress = new ItemProgressDialog(gui.getMainFrame(), "Parsing Files...", toParse.size());
        this.errors = new LinkedHashMap<String, String>();
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParserRunner.this.progress.setVisible(true);
            }
        });
        ParserLog log = ParserLog.getInstance();
        for (int i = 0; i < this.toParse.size(); ++i) {
            final String filename = this.toParse.get(i).replace('\\', '/');
            log.setCurrentFilename(filename);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String name = filename;
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        name = name.substring(idx + 1);
                    }
                    ParserRunner.this.progress.setCurrentItem(name);
                }
            });
            try {
                this.gui.parse(filename, this.timeZone);
            }
            catch (Exception e) {
                log.getLogger().error("could not parse " + filename, (Throwable)e);
            }
            if (log.hasData()) {
                this.errors.put(log.getCurrentFilename(), log.getMessages());
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ParserRunner.this.progress.updateProgress();
                    }
                });
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ParserRunner.this.progress != null) {
                    ParserRunner.this.progress.dispose();
                    if (!ParserRunner.this.errors.isEmpty()) {
                        new ParserErrorDialog(ParserRunner.this.gui, ParserRunner.this.errors).setVisible(true);
                    }
                }
            }
        });
    }
}

