/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.info;

import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ReadOnlyTableModel;
import com.ibm.nmon.gui.table.StringCellRenderer;
import com.ibm.nmon.interval.Interval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.table.TableColumnModel;

public final class MetadataInfoDialog
extends GUIDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = -482137072909463758L;
    private final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss MMM dd");
    private final JTabbedPane tabs;

    public MetadataInfoDialog(NMONVisualizerGui gui, SystemDataSet data) {
        super(gui, gui.getMainFrame(), "Parsed File Info - " + data.getHostname());
        this.setIconImage(Styles.buildIcon("page.png").getImage());
        this.format.setTimeZone(gui.getDisplayTimeZone());
        if (data.getMetadataCount() > 1) {
            this.tabs = new JTabbedPane();
            this.setContentPane(this.tabs);
            ToolTipManager.sharedInstance().registerComponent(this.tabs);
        } else {
            this.tabs = null;
        }
        JPanel tab = null;
        for (Interval interval : data.getSourceFileIntervals()) {
            tab = new JPanel(new BorderLayout());
            ReadOnlyTableModel model = new ReadOnlyTableModel();
            model.addColumn("Name");
            model.addColumn("Value");
            Map<String, String> metadata = data.getMetadata(interval.getStart());
            if (metadata.isEmpty()) continue;
            for (String name : metadata.keySet()) {
                model.addRow(new String[]{name, metadata.get(name)});
            }
            final GUITable table = new GUITable(gui, model);
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(0).setPreferredWidth(150);
            columnModel.getColumn(1).setPreferredWidth(350);
            columnModel.getColumn(0).setCellRenderer(new StringCellRenderer());
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.getViewport().setBackground(Color.WHITE);
            scrollPane.setBorder(Styles.LOWER_LINE_BORDER);
            tab.add((Component)scrollPane, "Center");
            JButton button = new JButton("Copy All");
            button.setIcon(Styles.COPY_ICON);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    table.selectAll();
                    table.getTransferHandler().exportToClipboard(table, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
                    table.removeRowSelectionInterval(0, table.getRowCount() - 1);
                }
            });
            JPanel panel = new JPanel();
            panel.add(button);
            tab.add((Component)panel, "Last");
            if (data.getMetadataCount() <= 1) continue;
            this.tabs.add(this.format.format(new Date(interval.getStart())), tab);
            this.tabs.setToolTipTextAt(this.tabs.getTabCount() - 1, data.getSourceFile(interval));
        }
        if (data.getMetadataCount() == 1) {
            this.setContentPane(tab);
        }
        gui.addPropertyChangeListener("timeZone", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.tabs != null) {
            int i;
            Date[] dates = new Date[this.tabs.getTabCount()];
            for (i = 0; i < this.tabs.getTabCount(); ++i) {
                try {
                    dates[i] = this.format.parse(this.tabs.getTitleAt(i));
                    continue;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            this.format.setTimeZone((TimeZone)evt.getNewValue());
            for (i = 0; i < this.tabs.getTabCount(); ++i) {
                this.tabs.setTitleAt(i, this.format.format(dates[i]));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.gui.removePropertyChangeListener("timeZone", this);
    }
}

