/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.info;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.tree.TreePathParser;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public final class ProcessInfoDialog
extends GUIDialog {
    private static final long serialVersionUID = -2090520968050107345L;
    private static final ImageIcon PROCESS_ICON = Styles.buildIcon("cog.png");
    private final JLabel processName;
    private final JLabel processTime;
    private final JTextArea commandLine;
    private final JCheckBox followTree;
    private JTree tree;
    private final TreeSelectionListener treeListener = new TreeSelectionListener(){
        private TreePathParser pathParser = new TreePathParser(){

            @Override
            protected void onTypePath(DataSet data, DataType type) {
                Process p;
                if (ProcessInfoDialog.this.followTree.isSelected() && type.getClass().equals(ProcessDataType.class) && (p = ((ProcessDataType)type).getProcess()).getId() != -1) {
                    ProcessInfoDialog.this.setProcess(p);
                }
            }
        };

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.pathParser.parse(e.getPath());
        }
    };

    public ProcessInfoDialog(NMONVisualizerGui gui) {
        super(gui);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.setIconImage(PROCESS_ICON.getImage());
        this.processName = new JLabel();
        this.processName.setFont(Styles.TITLE);
        this.processName.setHorizontalAlignment(0);
        this.processTime = new JLabel();
        this.processTime.setFont(Styles.BOLD);
        this.processTime.setHorizontalAlignment(0);
        JPanel header = new JPanel();
        header.setLayout(new GridLayout(2, 1));
        header.setBorder(Styles.TITLE_BORDER);
        header.add(this.processName);
        header.add(this.processTime);
        this.add((Component)header, "First");
        this.commandLine = new JTextArea();
        this.commandLine.setColumns(50);
        this.commandLine.setRows(15);
        this.commandLine.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.commandLine);
        scrollPane.setBorder(Styles.DOUBLE_LINE_BORDER);
        this.add((Component)scrollPane, "Center");
        this.followTree = new JCheckBox("Link with Tree?");
        this.followTree.setFont(Styles.LABEL);
        this.followTree.setHorizontalAlignment(11);
        this.followTree.setHorizontalTextPosition(10);
        this.followTree.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10));
        this.followTree.setSelected(false);
        this.add((Component)this.followTree, "Last");
        this.tree = null;
    }

    public ProcessInfoDialog(NMONVisualizerGui gui, JTree tree, Process process) {
        this(gui);
        this.linkToTree(tree);
        this.setProcess(process);
    }

    public void linkToTree(JTree tree) {
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.treeListener);
        }
        this.tree = tree;
        if (tree != null) {
            tree.addTreeSelectionListener(this.treeListener);
            this.followTree.setSelected(true);
        } else {
            this.followTree.setSelected(false);
        }
    }

    @Override
    public void dispose() {
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.treeListener);
        }
        super.dispose();
    }

    private void setProcess(Process process) {
        this.setTitle(process.getName() + " (" + process.getId() + ')' + " Command Line");
        this.processName.setText(process.getName() + " (" + process.getId() + ')');
        this.processTime.setText(TimeFormatCache.formatDateTime(process.getStartTime()) + " - " + TimeFormatCache.formatDateTime(process.getEndTime()));
        String[] parts = process.getCommandLine().split("\\s");
        StringBuilder builder = new StringBuilder(process.getCommandLine().length() + 100);
        int maxWidth = Integer.MIN_VALUE;
        for (int i = 0; i < parts.length - 1; ++i) {
            builder.append(parts[i]);
            builder.append('\n');
            if (parts[i].length() <= maxWidth) continue;
            maxWidth = parts[i].length();
        }
        builder.append(parts[parts.length - 1]);
        if (parts[parts.length - 1].length() > maxWidth) {
            maxWidth = parts[parts.length - 1].length();
        }
        this.commandLine.setText(builder.toString());
        this.commandLine.setCaretPosition(0);
    }
}

