/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.info;

import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;

public final class SystemInfoDialog
extends GUIDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = -5471229750755128948L;
    private final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss MMM dd");
    private final JTabbedPane tabs;

    public SystemInfoDialog(NMONVisualizerGui gui, SystemDataSet data) {
        super(gui, gui.getMainFrame(), "System Info - " + data.getHostname());
        this.setIconImage(Styles.buildIcon("computer.png").getImage());
        this.format.setTimeZone(gui.getDisplayTimeZone());
        if (data.getSystemInfoCount() > 1) {
            this.tabs = new JTabbedPane();
            this.tabs.setBorder(Styles.LOWER_LINE_BORDER);
            this.setContentPane(this.tabs);
            ToolTipManager.sharedInstance().registerComponent(this.tabs);
        } else {
            this.tabs = null;
        }
        JPanel tab = null;
        for (Interval interval : data.getSourceFileIntervals()) {
            tab = new JPanel(new BorderLayout());
            tab.setBorder(Styles.LOWER_LINE_BORDER);
            final JTabbedPane subTabs = new JTabbedPane();
            Map<String, String> systemInfo = data.getSystemInfo(interval.getStart());
            if (systemInfo.isEmpty()) continue;
            for (String name : systemInfo.keySet()) {
                JTextArea textArea = new JTextArea(systemInfo.get(name));
                textArea.setColumns(50);
                textArea.setRows(25);
                textArea.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setBorder(null);
                subTabs.addTab(name, scrollPane);
            }
            tab.add((Component)subTabs, "Center");
            JButton button = new JButton("Copy All");
            button.setIcon(Styles.COPY_ICON);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JScrollPane scrollPane = (JScrollPane)subTabs.getSelectedComponent();
                    JTextArea textArea = (JTextArea)scrollPane.getViewport().getView();
                    int n = textArea.getCaretPosition();
                    textArea.selectAll();
                    textArea.copy();
                    textArea.setCaretPosition(n);
                }
            });
            JPanel panel = new JPanel();
            panel.add(button);
            tab.add((Component)panel, "Last");
            if (data.getSystemInfoCount() <= 1) continue;
            this.tabs.add(this.format.format(new Date(interval.getStart())), tab);
            this.tabs.setToolTipTextAt(this.tabs.getTabCount() - 1, data.getSourceFile(interval));
        }
        if (data.getSystemInfoCount() == 1) {
            this.setContentPane(tab);
        }
        gui.addPropertyChangeListener("timeZone", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.tabs != null) {
            int i;
            Date[] dates = new Date[this.tabs.getTabCount()];
            for (i = 0; i < this.tabs.getTabCount(); ++i) {
                try {
                    dates[i] = this.format.parse(this.tabs.getTitleAt(i));
                    continue;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            this.format.setTimeZone((TimeZone)evt.getNewValue());
            for (i = 0; i < this.tabs.getTabCount(); ++i) {
                this.tabs.setTitleAt(i, this.format.format(dates[i]));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.gui.removePropertyChangeListener("timeZone", this);
    }
}

