/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.interval.BaseIntervalPanel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class AbsoluteTimeIntervalPanel
extends BaseIntervalPanel {
    private static final long serialVersionUID = 3451148920350034946L;
    private final JSpinner start;
    private final JSpinner end;
    private final JLabel startLabel;
    private final JLabel endLabel;
    private final ChangeListener intervalUpdater = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            long startTime = AbsoluteTimeIntervalPanel.this.getStartTime();
            long endTime = AbsoluteTimeIntervalPanel.this.getEndTime();
            if (endTime > startTime) {
                AbsoluteTimeIntervalPanel.this.startLabel.setFont(Styles.LABEL);
                AbsoluteTimeIntervalPanel.this.endLabel.setFont(Styles.LABEL);
                AbsoluteTimeIntervalPanel.this.startLabel.setForeground(Styles.DEFAULT_COLOR);
                AbsoluteTimeIntervalPanel.this.endLabel.setForeground(Styles.DEFAULT_COLOR);
                ((JSpinner.DefaultEditor)AbsoluteTimeIntervalPanel.this.start.getEditor()).getTextField().setForeground(Styles.DEFAULT_COLOR);
                ((JSpinner.DefaultEditor)AbsoluteTimeIntervalPanel.this.end.getEditor()).getTextField().setForeground(Styles.DEFAULT_COLOR);
                Interval i = new Interval(startTime, endTime);
                AbsoluteTimeIntervalPanel.this.firePropertyChange("interval", null, i);
            } else {
                AbsoluteTimeIntervalPanel.this.startLabel.setFont(Styles.LABEL_ERROR);
                AbsoluteTimeIntervalPanel.this.endLabel.setFont(Styles.LABEL_ERROR);
                AbsoluteTimeIntervalPanel.this.startLabel.setForeground(Styles.ERROR_COLOR);
                AbsoluteTimeIntervalPanel.this.endLabel.setForeground(Styles.ERROR_COLOR);
                ((JSpinner.DefaultEditor)AbsoluteTimeIntervalPanel.this.start.getEditor()).getTextField().setForeground(Styles.ERROR_COLOR);
                ((JSpinner.DefaultEditor)AbsoluteTimeIntervalPanel.this.end.getEditor()).getTextField().setForeground(Styles.ERROR_COLOR);
                AbsoluteTimeIntervalPanel.this.firePropertyChange("interval", null, null);
            }
        }
    };

    AbsoluteTimeIntervalPanel(NMONVisualizerGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.add.addActionListener(this.addInterval);
        this.startLabel = new JLabel("Start:");
        this.startLabel.setHorizontalAlignment(11);
        this.startLabel.setFont(Styles.LABEL);
        this.start = new JSpinner(new SpinnerDateModel(new Date(this.getDefaultStartTime()), null, null, 12));
        this.start.setEditor(new JSpinner.DateEditor(this.start, "HH:mm:ss MMM dd yyyy"));
        this.start.addChangeListener(this.intervalUpdater);
        this.endLabel = new JLabel("End:");
        this.endLabel.setHorizontalAlignment(11);
        this.endLabel.setFont(Styles.LABEL);
        this.end = new JSpinner(new SpinnerDateModel(new Date(this.getDefaultEndTime()), null, null, 12));
        this.end.setEditor(new JSpinner.DateEditor(this.end, "HH:mm:ss MMM dd yyyy"));
        this.end.addChangeListener(this.intervalUpdater);
        JPanel namePanel = new JPanel();
        namePanel.add(this.nameLabel);
        namePanel.add(this.name);
        JPanel startPanel = new JPanel();
        startPanel.add(this.startLabel);
        startPanel.add(this.start);
        JPanel endPanel = new JPanel();
        endPanel.add(this.endLabel);
        endPanel.add(this.end);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.add);
        buttonsPanel.add(this.endToStart);
        buttonsPanel.add(this.reset);
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        labelConstraints.insets = new Insets(0, 0, 0, 5);
        fieldConstraints.insets = new Insets(5, 0, 0, 5);
        labelConstraints.fill = 2;
        fieldConstraints.fill = 2;
        dataPanel.add((Component)this.startLabel, labelConstraints);
        dataPanel.add((Component)this.start, fieldConstraints);
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        dataPanel.add((Component)this.endLabel, labelConstraints);
        dataPanel.add((Component)this.end, fieldConstraints);
        this.add((Component)namePanel, "First");
        this.add((Component)dataPanel, "Center");
        this.add((Component)buttonsPanel, "Last");
    }

    @Override
    long getStartTime() {
        return ((Date)this.start.getValue()).getTime();
    }

    @Override
    long getEndTime() {
        return ((Date)this.end.getValue()).getTime();
    }

    @Override
    void setTimes(long start, long end) {
        this.start.setValue(new Date(start));
        this.end.setValue(new Date(end));
    }

    @Override
    TimeZone getTimeZone() {
        JSpinner.DateEditor de = (JSpinner.DateEditor)this.start.getEditor();
        return de.getFormat().getTimeZone();
    }

    @Override
    protected void setStartToEnd() {
        this.start.setValue(this.end.getValue());
        ((JSpinner.DefaultEditor)this.end.getEditor()).getTextField().requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            ((JSpinner.DefaultEditor)this.start.getEditor()).getTextField().requestFocus();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("timeZone".equals(evt.getPropertyName())) {
            TimeZone timeZone = (TimeZone)evt.getNewValue();
            JSpinner.DateEditor de = (JSpinner.DateEditor)this.start.getEditor();
            de.getFormat().setTimeZone(timeZone);
            ((SpinnerDateModel)this.start.getModel()).setCalendarField(12);
            ((SpinnerDateModel)this.start.getModel()).setCalendarField(13);
            de = (JSpinner.DateEditor)this.end.getEditor();
            de.getFormat().setTimeZone(timeZone);
            ((SpinnerDateModel)this.end.getModel()).setCalendarField(12);
            ((SpinnerDateModel)this.end.getModel()).setCalendarField(13);
        }
    }
}

