/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

abstract class BaseIntervalPanel
extends JPanel
implements DataSetListener,
PropertyChangeListener {
    private static final long serialVersionUID = 5417848225227158133L;
    protected final NMONVisualizerGui gui;
    protected final JTextField name;
    protected final JLabel nameLabel;
    protected final JButton add;
    protected final JButton reset;
    protected final JButton endToStart;
    protected final ActionListener addInterval = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            long startTime = BaseIntervalPanel.this.getStartTime();
            long endTime = BaseIntervalPanel.this.getEndTime();
            if (startTime != BaseIntervalPanel.this.gui.getMinSystemTime() || endTime != BaseIntervalPanel.this.gui.getMaxSystemTime()) {
                IntervalManager intervalManager = BaseIntervalPanel.this.gui.getIntervalManager();
                Interval i = null;
                try {
                    i = new Interval(startTime, endTime);
                    i.setName(BaseIntervalPanel.this.name.getText());
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(BaseIntervalPanel.this.getParent(), "Start time must be less than  End time", "Invalid Time", 0);
                    return;
                }
                if (intervalManager.addInterval(i)) {
                    BaseIntervalPanel.this.firePropertyChange("interval", intervalManager.getCurrentInterval(), i);
                    intervalManager.setCurrentInterval(i);
                }
            }
        }
    };

    BaseIntervalPanel(NMONVisualizerGui gui) {
        this.gui = gui;
        this.name = new JTextField(10);
        this.nameLabel = new JLabel("Interval Name:");
        this.nameLabel.setHorizontalAlignment(11);
        this.nameLabel.setFont(Styles.LABEL);
        this.add = new JButton("Add");
        this.add.setIcon(Styles.ADD_ICON);
        this.reset = new JButton("Reset");
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseIntervalPanel.this.setTimes(BaseIntervalPanel.this.getDefaultStartTime(), BaseIntervalPanel.this.getDefaultEndTime());
            }
        });
        AbstractAction endToStartAction = new AbstractAction(){
            private static final long serialVersionUID = -5385099678909892027L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseIntervalPanel.this.setStartToEnd();
            }
        };
        this.endToStart = new JButton("Start = End");
        this.endToStart.setIcon(Styles.buildIcon("arrow_up.png"));
        this.endToStart.addActionListener(endToStartAction);
        ActionMap actions = this.getActionMap();
        InputMap inputs = this.getInputMap(2);
        actions.put("endToStart", endToStartAction);
        inputs.put(KeyStroke.getKeyStroke(84, 128), "endToStart");
    }

    final String getIntervalName() {
        return this.name.getText();
    }

    final void setIntervalName(String name) {
        this.name.setText(name);
    }

    protected final long getDefaultStartTime() {
        if (this.gui.getDataSetCount() > 0) {
            return this.gui.getMinSystemTime();
        }
        return (System.currentTimeMillis() / 1000L - 43200L) * 1000L;
    }

    protected final long getDefaultEndTime() {
        if (this.gui.getDataSetCount() > 0) {
            return this.gui.getMaxSystemTime();
        }
        return (System.currentTimeMillis() / 1000L + 43200L) * 1000L;
    }

    abstract long getStartTime();

    abstract long getEndTime();

    abstract void setTimes(long var1, long var3);

    abstract TimeZone getTimeZone();

    protected abstract void setStartToEnd();

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.gui.addDataSetListener(this);
                this.gui.addPropertyChangeListener("timeZone", this);
                this.getRootPane().setDefaultButton(this.add);
            } else {
                this.gui.removeDataSetListener(this);
                this.gui.removePropertyChangeListener("timeZone", this);
                this.getRootPane().setDefaultButton(null);
            }
        }
    }

    @Override
    public final void dataAdded(DataSet file) {
        this.setTimes(this.getDefaultStartTime(), this.getDefaultEndTime());
    }

    @Override
    public final void dataRemoved(DataSet data) {
        this.setTimes(this.getDefaultStartTime(), this.getDefaultEndTime());
    }

    @Override
    public final void dataChanged(DataSet data) {
        this.setTimes(this.getDefaultStartTime(), this.getDefaultEndTime());
    }

    @Override
    public final void dataCleared() {
        this.setTimes(this.getDefaultStartTime(), this.getDefaultEndTime());
    }

    protected final void requestFocus(final JFormattedTextField field) {
        field.requestFocus();
        try {
            field.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                field.selectAll();
            }
        });
    }
}

