/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.interval.BulkIntervalPanel;
import com.ibm.nmon.gui.time.TimeMaskFormatter;
import com.ibm.nmon.interval.Interval;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

final class BulkDocumentListener
implements DocumentListener {
    private final BulkIntervalPanel bulkIntervalPanel;
    private final JFormattedTextField parent;
    private final JFormattedTextField duration;
    private final JFormattedTextField days;
    private final JFormattedTextField repeat;
    private final JFormattedTextField offset;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    BulkDocumentListener(BulkIntervalPanel bulkIntervalPanel, JFormattedTextField parent, JFormattedTextField duration, JFormattedTextField days, JFormattedTextField repeat, JFormattedTextField offset) {
        this.bulkIntervalPanel = bulkIntervalPanel;
        this.parent = parent;
        this.duration = duration;
        this.days = days;
        this.repeat = repeat;
        this.offset = offset;
    }

    @Override
    public final void removeUpdate(DocumentEvent e) {
    }

    @Override
    public final void insertUpdate(DocumentEvent e) {
        if (e.getLength() == 0) {
            return;
        }
        String text = null;
        try {
            text = e.getDocument().getText(e.getDocument().getStartPosition().getOffset(), e.getDocument().getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        int durationValue = -1;
        int daysValue = -1;
        int repeatValue = -1;
        int offsetValue = -1;
        if (e.getDocument() == this.duration.getDocument()) {
            try {
                durationValue = TimeMaskFormatter.parseTime(text);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            daysValue = (Integer)this.days.getValue();
            repeatValue = (Integer)this.repeat.getValue();
            offsetValue = (Integer)this.offset.getValue();
        } else if (e.getDocument() == this.days.getDocument()) {
            try {
                daysValue = Integer.parseInt(text);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            durationValue = (Integer)this.duration.getValue();
            repeatValue = (Integer)this.repeat.getValue();
            offsetValue = (Integer)this.offset.getValue();
        } else if (e.getDocument() == this.repeat.getDocument()) {
            try {
                repeatValue = Integer.parseInt(text);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            durationValue = (Integer)this.duration.getValue();
            daysValue = (Integer)this.days.getValue();
            offsetValue = (Integer)this.offset.getValue();
        } else if (e.getDocument() == this.offset.getDocument()) {
            try {
                offsetValue = TimeMaskFormatter.parseTime(text);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            durationValue = (Integer)this.duration.getValue();
            daysValue = (Integer)this.days.getValue();
            repeatValue = (Integer)this.repeat.getValue();
        } else {
            throw new IllegalStateException("unexpected parent " + this.parent);
        }
        long[] updatedValues = new long[]{durationValue, daysValue, repeatValue, offsetValue, -1L};
        if (daysValue != -1 && repeatValue != -1 && durationValue != -1 && offsetValue != -1) {
            long endTime;
            long startTime = this.bulkIntervalPanel.getStartTime();
            if (startTime < (endTime = this.bulkIntervalPanel.getEndTime(startTime, durationValue, daysValue, repeatValue, offsetValue))) {
                updatedValues[4] = endTime;
                Interval i = new Interval(startTime, endTime);
                this.propertyChangeSupport.firePropertyChange("interval", null, i);
            } else {
                this.propertyChangeSupport.firePropertyChange("interval", null, null);
            }
        }
        this.propertyChangeSupport.firePropertyChange("values", null, updatedValues);
    }

    @Override
    public final void changedUpdate(DocumentEvent e) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

