/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.interval.BaseIntervalPanel;
import com.ibm.nmon.gui.interval.BulkDocumentListener;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.time.TimeMaskFormatter;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public final class BulkIntervalPanel
extends BaseIntervalPanel {
    private static final long serialVersionUID = 1817418187436308391L;
    private final JSpinner start;
    private final JFormattedTextField duration;
    private final JFormattedTextField days;
    private final JFormattedTextField repeat;
    private final JFormattedTextField offset;
    private final JLabel end;
    private final JLabel durationLabel;
    private final JLabel repeatLabel;
    private final JLabel offsetLabel;
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss MMM dd");
    private final BulkDocumentListener durationListener;
    private final BulkDocumentListener daysListener;
    private final BulkDocumentListener repeatListener;
    private final BulkDocumentListener offsetListener;

    public BulkIntervalPanel(NMONVisualizerGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        JLabel startLabel = new JLabel("Start:");
        startLabel.setHorizontalAlignment(11);
        startLabel.setFont(Styles.LABEL);
        this.start = new JSpinner(new SpinnerDateModel(new Date(this.getDefaultStartTime()), null, null, 12));
        this.start.setEditor(new JSpinner.DateEditor(this.start, "HH:mm:ss MMM dd yyyy"));
        JLabel endLabel = new JLabel("End:");
        endLabel.setHorizontalAlignment(11);
        endLabel.setVerticalAlignment(3);
        endLabel.setFont(Styles.LABEL);
        this.end = new JLabel();
        this.end.setFont(Styles.BOLD);
        DefaultFormatter formatter = new DefaultFormatter();
        formatter.setValueClass(Integer.class);
        this.durationLabel = new JLabel("Duration:");
        this.durationLabel.setHorizontalAlignment(11);
        this.durationLabel.setFont(Styles.LABEL);
        this.duration = new JFormattedTextField();
        this.duration.setFormatterFactory(TimeMaskFormatter.createFormatterFactory(true));
        this.duration.setColumns(5);
        this.duration.setValue(0);
        this.days = new JFormattedTextField();
        this.days.setFormatterFactory(new DefaultFormatterFactory(formatter));
        this.days.setColumns(3);
        this.days.setValue(1);
        this.days.setHorizontalAlignment(11);
        this.repeatLabel = new JLabel("Repeat:");
        this.repeatLabel.setHorizontalAlignment(11);
        this.repeatLabel.setFont(Styles.LABEL);
        this.repeat = new JFormattedTextField();
        this.repeat.setFormatterFactory(new DefaultFormatterFactory(formatter));
        this.repeat.setColumns(3);
        this.repeat.setHorizontalAlignment(11);
        this.repeat.setValue(2);
        this.offsetLabel = new JLabel("Time Between:");
        this.offsetLabel.setHorizontalAlignment(11);
        this.offsetLabel.setFont(Styles.LABEL);
        this.offset = new JFormattedTextField();
        this.offset.setFormatterFactory(TimeMaskFormatter.createFormatterFactory(true));
        this.offset.setColumns(5);
        this.offset.setValue(0);
        this.end.setText(this.FORMAT.format(new Date(this.getEndTime())));
        JButton hourly = new JButton("1 Hour");
        hourly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar cal = Calendar.getInstance(BulkIntervalPanel.this.gui.getDisplayTimeZone());
                cal.setTime((Date)BulkIntervalPanel.this.start.getValue());
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                BulkIntervalPanel.this.start.setValue(cal.getTime());
                BulkIntervalPanel.this.duration.setValue(3600);
                BulkIntervalPanel.this.days.setValue(0);
                BulkIntervalPanel.this.requestFocus(BulkIntervalPanel.this.repeat);
            }
        });
        JButton daily = new JButton("1 Day");
        daily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar cal = Calendar.getInstance(BulkIntervalPanel.this.gui.getDisplayTimeZone());
                cal.setTime((Date)BulkIntervalPanel.this.start.getValue());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                BulkIntervalPanel.this.start.setValue(cal.getTime());
                BulkIntervalPanel.this.duration.setValue(0);
                BulkIntervalPanel.this.days.setValue(1);
                BulkIntervalPanel.this.requestFocus(BulkIntervalPanel.this.repeat);
            }
        });
        JPanel namePanel = new JPanel();
        namePanel.add(this.nameLabel);
        namePanel.add(this.name);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        labelConstraints.insets = new Insets(0, 0, 0, 5);
        fieldConstraints.insets = new Insets(5, 0, 0, 5);
        labelConstraints.fill = 2;
        fieldConstraints.fill = 2;
        fieldConstraints.gridwidth = 2;
        centerPanel.add((Component)startLabel, labelConstraints);
        centerPanel.add((Component)this.start, fieldConstraints);
        labelConstraints.gridx += 3;
        fieldConstraints.gridx += 3;
        centerPanel.add((Component)endLabel, labelConstraints);
        centerPanel.add((Component)this.end, fieldConstraints);
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        fieldConstraints.gridwidth = 1;
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        centerPanel.add((Component)this.durationLabel, labelConstraints);
        centerPanel.add((Component)this.duration, fieldConstraints);
        ++fieldConstraints.gridx;
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        centerPanel.add((Component)this.durationLabel, labelConstraints);
        centerPanel.add((Component)this.duration, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)new JLabel("HH:mm:ss"), fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)this.days, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)new JLabel("days"), fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)hourly, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)daily, fieldConstraints);
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        centerPanel.add((Component)this.repeatLabel, labelConstraints);
        centerPanel.add((Component)this.repeat, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)new JLabel("times"), fieldConstraints);
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        centerPanel.add((Component)this.offsetLabel, labelConstraints);
        centerPanel.add((Component)this.offset, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)new JLabel("HH:mm:ss"), fieldConstraints);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.add);
        buttonsPanel.add(this.endToStart);
        buttonsPanel.add(this.reset);
        this.add((Component)namePanel, "First");
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonsPanel, "Last");
        ActionListener addIntervals = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int repeatCount = (Integer)BulkIntervalPanel.this.repeat.getValue();
                if (repeatCount == 0) {
                    return;
                }
                if (repeatCount > 99) {
                    JOptionPane.showMessageDialog(BulkIntervalPanel.this.getParent(), "Repeat count must be less than 100", "Large Repeat Count", 2);
                    return;
                }
                long durationMillis = (long)((Integer)BulkIntervalPanel.this.duration.getValue()).intValue() * 1000L + (long)((Integer)BulkIntervalPanel.this.days.getValue()).intValue() * 86400000L;
                if (durationMillis == 0L) {
                    return;
                }
                long startTime = BulkIntervalPanel.this.getStartTime();
                IntervalManager intervalManager = BulkIntervalPanel.this.gui.getIntervalManager();
                Interval interval = null;
                for (int i = 0; i < repeatCount; ++i) {
                    long endTime = startTime + durationMillis;
                    interval = new Interval(startTime, endTime);
                    if (!"".equals(BulkIntervalPanel.this.name.getText())) {
                        interval.setName(BulkIntervalPanel.this.name.getText() + ' ' + (i + 1));
                    }
                    startTime = endTime + (long)((Integer)BulkIntervalPanel.this.offset.getValue()).intValue() * 1000L;
                    if (!intervalManager.addInterval(interval)) continue;
                    BulkIntervalPanel.this.firePropertyChange("interval", intervalManager.getCurrentInterval(), interval);
                }
                intervalManager.setCurrentInterval(interval);
            }
        };
        this.add.addActionListener(addIntervals);
        this.durationListener = new BulkDocumentListener(this, this.duration, this.duration, this.days, this.repeat, this.offset);
        this.daysListener = new BulkDocumentListener(this, this.days, this.duration, this.days, this.repeat, this.offset);
        this.repeatListener = new BulkDocumentListener(this, this.repeat, this.duration, this.days, this.repeat, this.offset);
        this.offsetListener = new BulkDocumentListener(this, this.repeat, this.duration, this.days, this.repeat, this.offset);
        this.duration.getDocument().addDocumentListener(this.durationListener);
        this.days.getDocument().addDocumentListener(this.daysListener);
        this.repeat.getDocument().addDocumentListener(this.repeatListener);
        this.offset.getDocument().addDocumentListener(this.offsetListener);
        this.durationListener.addPropertyChangeListener(this);
        this.daysListener.addPropertyChangeListener(this);
        this.repeatListener.addPropertyChangeListener(this);
        this.offsetListener.addPropertyChangeListener(this);
        this.start.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                long endTime;
                long startTime = BulkIntervalPanel.this.getStartTime();
                if (startTime < (endTime = BulkIntervalPanel.this.getEndTime())) {
                    Interval i = new Interval(startTime, endTime);
                    BulkIntervalPanel.this.firePropertyChange("interval", null, i);
                    BulkIntervalPanel.this.end.setText(BulkIntervalPanel.this.FORMAT.format(new Date(endTime)));
                }
            }
        });
    }

    @Override
    protected long getEndTime() {
        return this.getEndTime(this.getStartTime(), (Integer)this.duration.getValue(), (Integer)this.days.getValue(), (Integer)this.repeat.getValue(), (Integer)this.offset.getValue());
    }

    long getEndTime(long startTime, int duration, int days, int repeat, int offset) {
        return startTime + (long)((repeat * (duration + days * 86400 + offset) - offset) * 1000);
    }

    @Override
    long getStartTime() {
        return ((Date)this.start.getValue()).getTime();
    }

    @Override
    TimeZone getTimeZone() {
        JSpinner.DateEditor de = (JSpinner.DateEditor)this.start.getEditor();
        return de.getFormat().getTimeZone();
    }

    @Override
    protected void setStartToEnd() {
        this.start.setValue(new Date(this.getEndTime()));
        this.requestFocus(this.duration);
    }

    @Override
    protected void setTimes(long start, long end) {
        if (end > start) {
            int offsetMillis = (Integer)this.offset.getValue();
            int repeatCount = (Integer)this.repeat.getValue();
            long durationMillis = 0L;
            durationMillis = repeatCount == 0 ? end - start - (long)offsetMillis : (end - start - (long)(offsetMillis * (repeatCount - 1))) / (long)repeatCount;
            int numDays = (int)(durationMillis / 86400000L);
            int endTime = (int)(durationMillis / 1000L % 86400L);
            this.days.setValue(numDays);
            this.duration.setValue(endTime);
        } else {
            this.duration.setValue(0);
            this.days.setValue(0);
            this.end.setText(this.FORMAT.format(new Date(end)));
        }
        this.start.setValue(new Date(start));
        this.requestFocus(this.duration);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.requestFocus(this.duration);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.durationListener.addPropertyChangeListener(listener);
        this.daysListener.addPropertyChangeListener(listener);
        this.repeatListener.addPropertyChangeListener(listener);
        this.offsetListener.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("timeZone".equals(evt.getPropertyName())) {
            TimeZone timeZone = (TimeZone)evt.getNewValue();
            JSpinner.DateEditor de = (JSpinner.DateEditor)this.start.getEditor();
            de.getFormat().setTimeZone(timeZone);
            ((SpinnerDateModel)this.start.getModel()).setCalendarField(12);
            ((SpinnerDateModel)this.start.getModel()).setCalendarField(13);
            this.FORMAT.setTimeZone(timeZone);
            this.end.setText(this.FORMAT.format(this.getEndTime()));
        } else if ("values".equals(evt.getPropertyName())) {
            long[] updatedValues = (long[])evt.getNewValue();
            boolean validDuration = true;
            if (updatedValues[1] == 0L && updatedValues[0] < 1L) {
                validDuration = false;
            }
            if (validDuration) {
                this.durationLabel.setFont(Styles.LABEL);
                this.durationLabel.setForeground(Styles.DEFAULT_COLOR);
                this.duration.setForeground(Styles.DEFAULT_COLOR);
                this.days.setForeground(Styles.DEFAULT_COLOR);
            } else {
                this.durationLabel.setFont(Styles.LABEL_ERROR);
                this.durationLabel.setForeground(Styles.ERROR_COLOR);
                this.duration.setForeground(Styles.ERROR_COLOR);
                this.days.setForeground(Styles.ERROR_COLOR);
            }
            if (updatedValues[2] == 0L) {
                this.repeatLabel.setFont(Styles.LABEL_ERROR);
                this.repeatLabel.setForeground(Styles.ERROR_COLOR);
                this.repeat.setForeground(Styles.ERROR_COLOR);
                this.offset.setEnabled(false);
            } else {
                this.repeatLabel.setFont(Styles.LABEL);
                this.repeatLabel.setForeground(Styles.DEFAULT_COLOR);
                this.repeat.setForeground(Styles.DEFAULT_COLOR);
                if (updatedValues[2] == 1L) {
                    this.offset.setEnabled(false);
                } else {
                    this.offset.setEnabled(true);
                }
            }
            if (updatedValues[3] < 0L) {
                this.offsetLabel.setFont(Styles.LABEL_ERROR);
                this.offsetLabel.setForeground(Styles.ERROR_COLOR);
                this.offset.setForeground(Styles.ERROR_COLOR);
            } else {
                this.offsetLabel.setFont(Styles.LABEL);
                this.offsetLabel.setForeground(Styles.DEFAULT_COLOR);
                this.offset.setForeground(Styles.DEFAULT_COLOR);
            }
            if (updatedValues[4] != -1L) {
                this.end.setText(this.FORMAT.format(updatedValues[4]));
            }
        }
    }
}

