/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.interval.IntervalManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

final class IntervalComboBoxModel
extends AbstractListModel<Interval>
implements ComboBoxModel<Interval>,
PropertyChangeListener,
IntervalListener {
    private static final long serialVersionUID = -5885429600547069451L;
    private final IntervalManager manager;
    private final List<Interval> intervals = new LinkedList<Interval>();
    private Interval selected;

    public IntervalComboBoxModel(IntervalManager manager) {
        this.manager = manager;
        for (Interval interval : manager.getIntervals()) {
            this.intervals.add(interval);
        }
        Collections.sort(this.intervals);
        this.selected = manager.getCurrentInterval();
        manager.addListener(this);
    }

    @Override
    public Interval getElementAt(int index) {
        if (index == 0) {
            return Interval.DEFAULT;
        }
        return this.intervals.get(index - 1);
    }

    @Override
    public int getSize() {
        return this.intervals.size() + 1;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.selectionChanged(anItem)) {
            this.manager.setCurrentInterval(this.selected);
        }
    }

    @Override
    public void intervalAdded(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (this.intervals.get(i).compareTo(interval) < 0) continue;
            this.intervals.add(i, interval);
            this.fireIntervalAdded(this, i + 1, i + 1);
            return;
        }
        this.intervals.add(interval);
        this.fireIntervalAdded(this, this.intervals.size(), this.intervals.size());
    }

    @Override
    public void intervalRemoved(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(interval)) continue;
            this.intervals.remove(i);
            this.fireIntervalRemoved(this, i + 1, i + 1);
            return;
        }
    }

    @Override
    public void intervalsCleared() {
        this.intervals.clear();
        this.selected = Interval.DEFAULT;
        this.fireContentsChanged(this, 1, Integer.MAX_VALUE);
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        if (this.selectionChanged(interval)) {
            this.fireContentsChanged(this, 0, 0);
        }
    }

    @Override
    public void intervalRenamed(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(interval)) continue;
            this.fireContentsChanged(this, i + 1, i + 1);
            return;
        }
    }

    private boolean selectionChanged(Object anItem) {
        if (this.selected.equals(anItem)) {
            return false;
        }
        if (this.intervals.contains(anItem)) {
            this.selected = (Interval)anItem;
            return true;
        }
        if (Interval.DEFAULT.equals(anItem)) {
            this.selected = Interval.DEFAULT;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

