/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.GUITable;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.interval.IntervalTableModel;
import com.ibm.nmon.gui.interval.RemoveAllIntervalsAction;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.StringCellRenderer;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

final class IntervalList
extends JPanel
implements HierarchyListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2227815465031324337L;
    private final GUITable intervals;
    private final NMONVisualizerGui gui;

    public IntervalList(NMONVisualizerGui gui) {
        this.setLayout(new BorderLayout());
        this.gui = gui;
        IntervalTableModel model = new IntervalTableModel(gui);
        this.intervals = new GUITable(gui, model);
        this.intervals.getCellEditor(0, 0).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int selectedRow = IntervalList.this.intervals.getSelectedRow();
                Interval i = ((IntervalTableModel)IntervalList.this.intervals.getModel()).getValueAt(selectedRow);
                String newName = (String)IntervalList.this.intervals.getCellEditor(selectedRow, 0).getCellEditorValue();
                IntervalList.this.gui.getIntervalManager().renameInterval(i, newName);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.intervals.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 7101632198507145234L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(TimeFormatCache.formatDateTime((Long)value));
                Interval i = ((IntervalTableModel)table.getModel()).getValueAt(row);
                if (i.equals(IntervalList.this.gui.getIntervalManager().getCurrentInterval())) {
                    this.setFont(this.getFont().deriveFont(1));
                }
                return this;
            }
        });
        this.intervals.setDefaultRenderer(String.class, new StringCellRenderer());
        this.intervals.setSelectionMode(0);
        this.intervals.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int row = IntervalList.this.intervals.getSelectedRow();
                    Interval interval = null;
                    interval = row >= 0 ? ((IntervalTableModel)IntervalList.this.intervals.getModel()).getValueAt(row) : Interval.DEFAULT;
                    IntervalList.this.firePropertyChange("interval", null, interval);
                }
            }
        });
        JLabel label = new JLabel("Intervals");
        label.setFont(Styles.LABEL);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 0));
        this.add((Component)label, "First");
        JScrollPane scrollPane = new JScrollPane(this.intervals);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setPreferredSize(new Dimension(600, 150));
        scrollPane.setBorder(Styles.DOUBLE_LINE_BORDER);
        this.add((Component)scrollPane, "Center");
        RemoveAllIntervalsAction removeAllAction = new RemoveAllIntervalsAction(gui, this);
        final JButton clear = new JButton("Clear");
        clear.setIcon(Styles.CLEAR_ICON);
        clear.addActionListener(removeAllAction);
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalList.this.firePropertyChange("interval", null, IntervalList.this.gui.getIntervalManager().getCurrentInterval());
            }
        });
        JPanel temp = new JPanel();
        temp.add(clear);
        this.add((Component)temp, "Last");
        this.getActionMap().put("clear", new AbstractAction(){
            private static final long serialVersionUID = 317117736111534324L;

            @Override
            public void actionPerformed(ActionEvent e) {
                clear.doClick();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(127, 128), "clear");
    }

    GUITable getTable() {
        return this.intervals;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            if (e.getChanged().isVisible()) {
                this.gui.addPropertyChangeListener("timeZone", this);
                this.gui.getIntervalManager().addListener((IntervalTableModel)this.intervals.getModel());
            } else {
                this.gui.removePropertyChangeListener("timeZone", this);
                this.gui.getIntervalManager().removeListener((IntervalTableModel)this.intervals.getModel());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("timeZone".equals(evt.getPropertyName())) {
            ((IntervalTableModel)this.intervals.getModel()).fireTableDataChanged();
        }
    }
}

