/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.GUIDialog;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.file.IntervalFileChooser;
import com.ibm.nmon.gui.interval.AbsoluteTimeIntervalPanel;
import com.ibm.nmon.gui.interval.BaseIntervalPanel;
import com.ibm.nmon.gui.interval.BulkIntervalPanel;
import com.ibm.nmon.gui.interval.IntervalList;
import com.ibm.nmon.gui.interval.IntervalTableModel;
import com.ibm.nmon.gui.interval.RelativeTimeIntervalPanel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.time.SystemTimeList;
import com.ibm.nmon.gui.time.SystemTimeTableModel;
import com.ibm.nmon.gui.util.TimeZoneComboBox;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.interval.IntervalManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class IntervalManagerDialog
extends GUIDialog
implements IntervalListener {
    private static final long serialVersionUID = 4964215301504994528L;
    private final IntervalList intervals;
    private final SystemTimeList systemTimes;
    private final AbsoluteTimeIntervalPanel absolute;
    private final RelativeTimeIntervalPanel relative;
    private final BulkIntervalPanel bulk;
    private final TimeZoneComboBox timeZones;
    private final JButton save;
    private IntervalFileChooser fileChooser;
    private final MouseAdapter intervalsMenu = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseReleased(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = IntervalManagerDialog.this.intervals.getTable().rowAtPoint(e.getPoint());
            if (e.isPopupTrigger() && row >= 0) {
                IntervalManagerDialog.this.intervals.getTable().changeSelection(row, 0, false, false);
                final Interval interval = ((IntervalTableModel)IntervalManagerDialog.this.intervals.getTable().getModel()).getValueAt(row);
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = null;
                item = new JMenuItem("Use as Start & End");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BaseIntervalPanel active = null;
                        if (IntervalManagerDialog.this.absolute.isEnabled()) {
                            active = IntervalManagerDialog.this.absolute;
                        } else if (IntervalManagerDialog.this.relative.isEnabled()) {
                            active = IntervalManagerDialog.this.relative;
                        } else if (IntervalManagerDialog.this.bulk.isEnabled()) {
                            active = IntervalManagerDialog.this.bulk;
                        }
                        if (active != null) {
                            ((BaseIntervalPanel)active).setTimes(interval.getStart(), interval.getEnd());
                            active.revalidate();
                        }
                    }
                });
                menu.add(item);
                if (!interval.equals(IntervalManagerDialog.this.gui.getIntervalManager().getCurrentInterval())) {
                    item = new JMenuItem("Set as Current");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            IntervalManagerDialog.this.gui.getIntervalManager().setCurrentInterval(interval);
                            IntervalManagerDialog.this.intervals.getTable().repaint();
                        }
                    });
                    menu.add(item);
                }
                menu.addSeparator();
                item = new JMenuItem("Rename");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IntervalManagerDialog.this.intervals.getTable().editCellAt(IntervalManagerDialog.this.intervals.getTable().getSelectedRow(), 0);
                    }
                });
                menu.add(item);
                menu.addSeparator();
                item = new JMenuItem("Remove");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IntervalManagerDialog.this.gui.getIntervalManager().removeInterval(interval);
                        IntervalManagerDialog.this.intervals.getTable().repaint();
                    }
                });
                menu.add(item);
                menu.show(e.getComponent(), e.getX(), e.getY());
                IntervalManagerDialog.this.systemTimes.getTable().clearSelection();
            }
        }
    };
    private final MouseAdapter systemTimesMenu = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseReleased(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = IntervalManagerDialog.this.systemTimes.getTable().rowAtPoint(e.getPoint());
            if (e.isPopupTrigger() && row >= 0) {
                IntervalManagerDialog.this.systemTimes.getTable().changeSelection(row, 0, false, false);
                final DataSet data = ((SystemTimeTableModel)IntervalManagerDialog.this.systemTimes.getTable().getModel()).getValueAt(row);
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Use as Start & End");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BaseIntervalPanel active = null;
                        if (IntervalManagerDialog.this.absolute.isEnabled()) {
                            active = IntervalManagerDialog.this.absolute;
                        } else if (IntervalManagerDialog.this.relative.isEnabled()) {
                            active = IntervalManagerDialog.this.relative;
                        } else if (IntervalManagerDialog.this.bulk.isEnabled()) {
                            active = IntervalManagerDialog.this.bulk;
                        }
                        if (active != null) {
                            ((BaseIntervalPanel)active).setTimes(data.getStartTime(), data.getEndTime());
                            active.revalidate();
                        }
                    }
                });
                menu.add(item);
                item = new JMenuItem("Add Interval");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        long startTime = data.getStartTime();
                        long endTime = data.getEndTime();
                        NMONVisualizerGui gui = IntervalManagerDialog.this.gui;
                        if (startTime != gui.getMinSystemTime() || endTime != gui.getMaxSystemTime()) {
                            Interval i;
                            IntervalManager intervalManager = gui.getIntervalManager();
                            if (intervalManager.addInterval(i = new Interval(startTime, endTime))) {
                                IntervalManagerDialog.this.firePropertyChange("interval", intervalManager.getCurrentInterval(), i);
                                intervalManager.setCurrentInterval(i);
                            }
                            gui.getIntervalManager().addInterval(new Interval(startTime, endTime));
                        }
                    }
                });
                menu.add(item);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };
    private final ChangeListener timeSynchronizer = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            BaseIntervalPanel previous = null;
            if (IntervalManagerDialog.this.absolute.isEnabled()) {
                previous = IntervalManagerDialog.this.absolute;
            } else if (IntervalManagerDialog.this.relative.isEnabled()) {
                previous = IntervalManagerDialog.this.relative;
            } else if (IntervalManagerDialog.this.bulk.isEnabled()) {
                previous = IntervalManagerDialog.this.bulk;
            } else {
                return;
            }
            JTabbedPane tabs = (JTabbedPane)e.getSource();
            BaseIntervalPanel current = (BaseIntervalPanel)tabs.getSelectedComponent();
            if (current != null) {
                current.setIntervalName(previous.getIntervalName());
                current.setTimes(previous.getStartTime(), previous.getEndTime());
                current.setEnabled(true);
            }
            previous.setEnabled(false);
            current.propertyChange(new PropertyChangeEvent(this, "timeZone", null, previous.getTimeZone()));
        }
    };
    private final PropertyChangeListener focusManager = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null) {
                if (SwingUtilities.isDescendingFrom((Component)evt.getNewValue(), IntervalManagerDialog.this.absolute.getParent())) {
                    IntervalManagerDialog.this.intervals.getTable().clearSelection();
                    IntervalManagerDialog.this.systemTimes.getTable().clearSelection();
                } else if (IntervalManagerDialog.this.intervals.getTable() == evt.getNewValue()) {
                    IntervalManagerDialog.this.systemTimes.getTable().clearSelection();
                }
            }
        }
    };

    public IntervalManagerDialog(NMONVisualizerGui gui) {
        super(gui, gui.getMainFrame(), "Manage Intervals");
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        this.setIconImage(Styles.INTERVAL_ICON.getImage());
        this.timeZones = new TimeZoneComboBox(gui.getDisplayTimeZone());
        this.timeZones.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalManagerDialog.this.gui.setDisplayTimeZone(IntervalManagerDialog.this.timeZones.getSelectedTimeZone());
            }
        });
        JPanel timePanel = new JPanel();
        JLabel label = new JLabel("Time Zone:");
        label.setHorizontalAlignment(11);
        label.setFont(Styles.LABEL);
        timePanel.add(label);
        timePanel.add(this.timeZones);
        AbstractAction loadAction = new AbstractAction(){
            private static final long serialVersionUID = -8590641369327623520L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntervalManagerDialog.this.fileChooser == null) {
                    IntervalManagerDialog.this.fileChooser = new IntervalFileChooser(IntervalManagerDialog.this.gui);
                }
                IntervalManagerDialog.this.fileChooser.load();
            }
        };
        JButton load = new JButton("Load");
        load.addActionListener(loadAction);
        AbstractAction saveAction = new AbstractAction(){
            private static final long serialVersionUID = 8726615183618542317L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IntervalManagerDialog.this.fileChooser == null) {
                    IntervalManagerDialog.this.fileChooser = new IntervalFileChooser(IntervalManagerDialog.this.gui);
                }
                IntervalManagerDialog.this.fileChooser.save();
            }
        };
        this.save = new JButton("Save"){
            private static final long serialVersionUID = 4862470165493725505L;

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                if (b) {
                    ((JPanel)IntervalManagerDialog.this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(83, 128), "save");
                } else {
                    ((JPanel)IntervalManagerDialog.this.getContentPane()).getInputMap(2).remove(KeyStroke.getKeyStroke(83, 128));
                }
            }
        };
        this.save.setIcon(Styles.SAVE_ICON);
        this.save.addActionListener(saveAction);
        JPanel buttons = new JPanel();
        buttons.add(load);
        buttons.add(this.save);
        JPanel filler = new JPanel();
        filler.setPreferredSize(buttons.getPreferredSize());
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)filler, "Before");
        temp.add((Component)timePanel, "Center");
        temp.add((Component)buttons, "After");
        this.add(temp);
        this.absolute = new AbsoluteTimeIntervalPanel(gui);
        this.relative = new RelativeTimeIntervalPanel(gui);
        this.bulk = new BulkIntervalPanel(gui);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Bulk", this.bulk);
        tabs.add("Relative", this.relative);
        tabs.add("Absolute", this.absolute);
        tabs.setMnemonicAt(0, 66);
        tabs.setMnemonicAt(1, 82);
        tabs.setMnemonicAt(2, 65);
        this.add(tabs);
        this.intervals = new IntervalList(gui);
        this.intervals.setBorder(Styles.DOUBLE_LINE_BORDER);
        this.add(this.intervals);
        this.systemTimes = new SystemTimeList(gui);
        this.add(this.systemTimes);
        tabs.addChangeListener(this.timeSynchronizer);
        this.systemTimes.getTable().addMouseListener(this.systemTimesMenu);
        this.intervals.getTable().addMouseListener(this.intervalsMenu);
        this.addHierarchyListener(this.intervals);
        this.addHierarchyListener(this.systemTimes);
        this.intervals.addPropertyChangeListener("interval", this.systemTimes);
        this.absolute.addPropertyChangeListener("interval", this.systemTimes);
        this.relative.addPropertyChangeListener("interval", this.systemTimes);
        this.bulk.addPropertyChangeListener("interval", this.systemTimes);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusManager);
        JPanel content = (JPanel)this.getContentPane();
        ActionMap actions = content.getActionMap();
        InputMap inputs = content.getInputMap(2);
        actions.put("load", loadAction);
        actions.put("save", saveAction);
        inputs.put(KeyStroke.getKeyStroke(79, 128), "load");
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.bulk.setEnabled(false);
        this.bulk.setEnabled(true);
        this.relative.setEnabled(false);
        this.absolute.setEnabled(false);
        this.save.setEnabled(this.gui.getIntervalManager().getIntervalCount() != 0);
        this.gui.getIntervalManager().addListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.gui.getIntervalManager().removeListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusManager);
        this.absolute.setEnabled(false);
        this.relative.setEnabled(false);
        this.bulk.setEnabled(false);
    }

    @Override
    public void intervalAdded(Interval interval) {
        this.save.setEnabled(true);
    }

    @Override
    public void intervalRemoved(Interval interval) {
        this.save.setEnabled(this.gui.getIntervalManager().getIntervalCount() != 0);
    }

    @Override
    public void intervalsCleared() {
        this.save.setEnabled(false);
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        this.intervals.repaint();
    }

    @Override
    public void intervalRenamed(Interval interval) {
        this.intervals.repaint();
    }
}

