/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.interval.IntervalComboBoxModel;
import com.ibm.nmon.gui.interval.IntervalManagerDialog;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.util.TimeFormatCache;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public final class IntervalPicker
extends JPanel
implements DataSetListener {
    private static final long serialVersionUID = 5742043118375163400L;
    private final NMONVisualizerGui gui;
    private final JComboBox<Interval> intervals;

    public IntervalPicker(NMONVisualizerGui gui) {
        assert (gui != null);
        this.gui = gui;
        JLabel label = new JLabel("Interval:");
        label.setHorizontalAlignment(11);
        label.setFont(Styles.LABEL);
        this.add(label);
        this.intervals = new JComboBox<Interval>(new IntervalComboBoxModel(gui.getIntervalManager()));
        this.intervals.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1999400159683985218L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Interval i = (Interval)value;
                this.setText(TimeFormatCache.formatInterval(i));
                return c;
            }
        });
        this.add(this.intervals);
        JButton manageIntervals = new JButton("Manage");
        manageIntervals.setIcon(Styles.INTERVAL_ICON);
        manageIntervals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new IntervalManagerDialog(IntervalPicker.this.gui).setVisible(true);
            }
        });
        this.add(manageIntervals);
        gui.addPropertyChangeListener("timeZone", (IntervalComboBoxModel)this.intervals.getModel());
        gui.addDataSetListener(this);
    }

    @Override
    public void dataAdded(DataSet data) {
        this.updateOnDataChange();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.updateOnDataChange();
    }

    @Override
    public void dataChanged(DataSet data) {
        this.updateOnDataChange();
    }

    @Override
    public void dataCleared() {
        this.updateOnDataChange();
    }

    private void updateOnDataChange() {
        ((IntervalComboBoxModel)this.intervals.getModel()).propertyChange(null);
    }
}

