/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class IntervalTableModel
extends AbstractTableModel
implements IntervalListener {
    private static final long serialVersionUID = 8444774364976685957L;
    private static final String[] columnNames = new String[]{"Name", "Start", "End"};
    private final List<Interval> intervals = new LinkedList<Interval>();

    IntervalTableModel(NMONVisualizerGui gui) {
        for (Interval interval : gui.getIntervalManager().getIntervals()) {
            this.intervals.add(interval);
        }
        Collections.sort(this.intervals);
    }

    @Override
    public int getRowCount() {
        return this.intervals.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return Long.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.intervals.get(rowIndex).getName();
            }
            case 1: {
                return this.intervals.get(rowIndex).getStart();
            }
            case 2: {
                return this.intervals.get(rowIndex).getEnd();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Interval getValueAt(int rowIndex) {
        return this.intervals.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void intervalAdded(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (this.intervals.get(i).compareTo(interval) < 0) continue;
            this.intervals.add(i, interval);
            this.fireTableRowsInserted(i, i);
            return;
        }
        this.intervals.add(interval);
        this.fireTableRowsInserted(this.intervals.size() - 1, this.intervals.size() - 1);
    }

    @Override
    public void intervalRemoved(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(interval)) continue;
            this.intervals.remove(i);
            this.fireTableRowsDeleted(i, i);
            return;
        }
    }

    @Override
    public void intervalsCleared() {
        this.intervals.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
    }

    @Override
    public void intervalRenamed(Interval interval) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(interval)) continue;
            this.fireTableRowsUpdated(i, i);
            return;
        }
    }
}

