/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.interval.RelativeTimeIntervalPanel;
import com.ibm.nmon.gui.time.TimeMaskFormatter;
import com.ibm.nmon.interval.Interval;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

final class RelativeTimeDocumentListener
implements DocumentListener {
    private final RelativeTimeIntervalPanel relativeTimeIntervalPanel;
    private final JFormattedTextField parent;
    private final JFormattedTextField start;
    private final JFormattedTextField end;
    private final JFormattedTextField days;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    RelativeTimeDocumentListener(RelativeTimeIntervalPanel relativeTimeIntervalPanel, JFormattedTextField parent, JFormattedTextField start, JFormattedTextField end, JFormattedTextField days) {
        this.relativeTimeIntervalPanel = relativeTimeIntervalPanel;
        this.parent = parent;
        this.start = start;
        this.end = end;
        this.days = days;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e.getLength() == 0) {
            return;
        }
        try {
            String text = e.getDocument().getText(e.getDocument().getStartPosition().getOffset(), e.getDocument().getLength());
            int startValue = -1;
            int endValue = -1;
            int daysValue = -1;
            String property = null;
            if (this.parent == this.start) {
                try {
                    startValue = TimeMaskFormatter.parseTime(text);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                endValue = (Integer)this.end.getValue();
                daysValue = (Integer)this.days.getValue();
                property = "start";
            } else if (this.parent == this.end) {
                try {
                    endValue = TimeMaskFormatter.parseTime(text);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                startValue = (Integer)this.start.getValue();
                daysValue = (Integer)this.days.getValue();
                property = "end";
            } else if (this.parent == this.days) {
                try {
                    daysValue = Integer.parseInt(text);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                startValue = (Integer)this.start.getValue();
                endValue = (Integer)this.end.getValue();
                property = "end";
            } else {
                throw new IllegalStateException("unexpected parent " + this.parent);
            }
            if (startValue != -1 && endValue != -1 && daysValue != -1) {
                long endTime;
                long startTime = this.relativeTimeIntervalPanel.getStartTime(startValue);
                if (startTime < (endTime = this.relativeTimeIntervalPanel.getEndTime(endValue, daysValue))) {
                    this.propertyChangeSupport.firePropertyChange("interval", null, new Interval(startTime, endTime));
                } else {
                    this.propertyChangeSupport.firePropertyChange("interval", null, null);
                }
                if ("start".equals(property)) {
                    this.propertyChangeSupport.firePropertyChange(property, null, startTime);
                } else {
                    this.propertyChangeSupport.firePropertyChange(property, null, endTime);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

