/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.interval;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.interval.BaseIntervalPanel;
import com.ibm.nmon.gui.interval.RelativeTimeDocumentListener;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.time.TimeMaskFormatter;
import com.ibm.nmon.interval.Interval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

final class RelativeTimeIntervalPanel
extends BaseIntervalPanel {
    private static final long serialVersionUID = -1611515609994676644L;
    private final JSpinner base;
    private final JFormattedTextField start;
    private final JFormattedTextField end;
    private final JFormattedTextField days;
    private final JLabel startLabel;
    private final JLabel endLabel;
    private final JLabel startAbsolute;
    private final JLabel endAbsolute;
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss MMM dd");
    private final RelativeTimeDocumentListener startListener;
    private final RelativeTimeDocumentListener endListener;
    private final RelativeTimeDocumentListener daysListener;

    RelativeTimeIntervalPanel(NMONVisualizerGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.add.addActionListener(this.addInterval);
        JLabel baseLabel = new JLabel("Base Time:");
        baseLabel.setHorizontalAlignment(11);
        baseLabel.setFont(Styles.LABEL);
        this.base = new JSpinner(new SpinnerDateModel(new Date(this.getDefaultStartTime()), null, null, 12));
        this.base.setEditor(new JSpinner.DateEditor(this.base, "HH:mm:ss MMM dd yyyy"));
        this.base.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                long startTime = RelativeTimeIntervalPanel.this.getStartTime();
                long endTime = RelativeTimeIntervalPanel.this.getEndTime();
                RelativeTimeIntervalPanel.this.startAbsolute.setText(RelativeTimeIntervalPanel.this.FORMAT.format(new Date(RelativeTimeIntervalPanel.this.getStartTime())));
                RelativeTimeIntervalPanel.this.endAbsolute.setText(RelativeTimeIntervalPanel.this.FORMAT.format(new Date(RelativeTimeIntervalPanel.this.getEndTime())));
                if (startTime < endTime) {
                    Interval i = new Interval(startTime, endTime);
                    RelativeTimeIntervalPanel.this.firePropertyChange("interval", null, i);
                }
            }
        });
        this.startLabel = new JLabel("Start:");
        this.startLabel.setFont(Styles.LABEL);
        this.startLabel.setHorizontalAlignment(11);
        this.start = new JFormattedTextField();
        this.start.setName("start");
        this.start.setFormatterFactory(TimeMaskFormatter.createFormatterFactory(true));
        this.start.setColumns(5);
        this.start.setValue(0);
        this.endLabel = new JLabel("End:");
        this.endLabel.setFont(Styles.LABEL);
        this.endLabel.setHorizontalAlignment(11);
        this.end = new JFormattedTextField();
        this.end.setName("end");
        this.end.setFormatterFactory(TimeMaskFormatter.createFormatterFactory(false));
        this.end.setColumns(5);
        this.end.setValue(0);
        DefaultFormatter formatter = new DefaultFormatter();
        formatter.setValueClass(Integer.class);
        this.days = new JFormattedTextField();
        this.days.setFormatterFactory(new DefaultFormatterFactory(formatter));
        this.days.setColumns(3);
        this.days.setValue(0);
        this.days.setHorizontalAlignment(11);
        this.startAbsolute = new JLabel();
        this.startAbsolute.setFont(Styles.BOLD);
        this.endAbsolute = new JLabel();
        this.endAbsolute.setFont(Styles.BOLD);
        JPanel namePanel = new JPanel();
        namePanel.add(this.nameLabel);
        namePanel.add(this.name);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        fieldConstraints.gridx = 1;
        labelConstraints.gridy = 0;
        fieldConstraints.gridy = 0;
        labelConstraints.insets = new Insets(0, 0, 0, 5);
        fieldConstraints.insets = new Insets(5, 0, 0, 5);
        labelConstraints.fill = 2;
        fieldConstraints.fill = 2;
        JLabel hhmmss = new JLabel("HH:mm:ss");
        fieldConstraints.gridwidth = 2;
        centerPanel.add((Component)baseLabel, labelConstraints);
        centerPanel.add((Component)this.base, fieldConstraints);
        fieldConstraints.gridwidth = 1;
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        centerPanel.add((Component)this.startLabel, labelConstraints);
        centerPanel.add((Component)this.start, fieldConstraints);
        ++fieldConstraints.gridx;
        fieldConstraints.gridwidth = 3;
        centerPanel.add((Component)hhmmss, fieldConstraints);
        fieldConstraints.gridx += 3;
        fieldConstraints.gridwidth = 1;
        centerPanel.add((Component)this.startAbsolute, fieldConstraints);
        fieldConstraints.gridx = 1;
        ++labelConstraints.gridy;
        ++fieldConstraints.gridy;
        hhmmss = new JLabel("HH:mm:ss");
        JLabel daysLabel = new JLabel("days");
        centerPanel.add((Component)this.endLabel, labelConstraints);
        centerPanel.add((Component)this.end, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)hhmmss, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)this.days, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)daysLabel, fieldConstraints);
        ++fieldConstraints.gridx;
        centerPanel.add((Component)this.endAbsolute, fieldConstraints);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.add);
        buttonsPanel.add(this.endToStart);
        buttonsPanel.add(this.reset);
        this.add((Component)namePanel, "First");
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonsPanel, "Last");
        this.startListener = new RelativeTimeDocumentListener(this, this.start, this.start, this.end, this.days);
        this.endListener = new RelativeTimeDocumentListener(this, this.end, this.start, this.end, this.days);
        this.daysListener = new RelativeTimeDocumentListener(this, this.days, this.start, this.end, this.days);
        this.start.getDocument().addDocumentListener(this.startListener);
        this.end.getDocument().addDocumentListener(this.endListener);
        this.days.getDocument().addDocumentListener(this.daysListener);
        this.startListener.addPropertyChangeListener(this);
        this.endListener.addPropertyChangeListener(this);
        this.daysListener.addPropertyChangeListener(this);
    }

    private long getBaseTime() {
        return ((Date)this.base.getValue()).getTime();
    }

    @Override
    protected long getStartTime() {
        return this.getStartTime((Integer)this.start.getValue());
    }

    long getStartTime(int start) {
        return this.getBaseTime() + (long)start * 1000L;
    }

    @Override
    long getEndTime() {
        return this.getEndTime((Integer)this.end.getValue(), (Integer)this.days.getValue());
    }

    long getEndTime(int end, int days) {
        return this.getBaseTime() + (long)end * 1000L + (long)days * 86400000L;
    }

    @Override
    void setTimes(long start, long end) {
        long base = start - (long)((Integer)this.start.getValue() * 1000);
        if (end > start) {
            long diff = end - base;
            int numDays = (int)(diff / 86400000L);
            int endTime = (int)(diff / 1000L % 86400L);
            this.days.setValue(numDays);
            this.end.setValue(endTime);
        }
        this.base.setValue(new Date(base));
    }

    @Override
    TimeZone getTimeZone() {
        JSpinner.DateEditor de = (JSpinner.DateEditor)this.base.getEditor();
        return de.getFormat().getTimeZone();
    }

    @Override
    protected void setStartToEnd() {
        this.start.setValue(this.end.getValue());
        this.requestFocus(this.start);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.requestFocus(this.start);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.startListener.addPropertyChangeListener(listener);
        this.endListener.addPropertyChangeListener(listener);
        this.daysListener.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("interval".equals(evt.getPropertyName())) {
            if (evt.getNewValue() == null) {
                this.startLabel.setFont(Styles.LABEL_ERROR);
                this.endLabel.setFont(Styles.LABEL_ERROR);
                this.startLabel.setForeground(Styles.ERROR_COLOR);
                this.endLabel.setForeground(Styles.ERROR_COLOR);
                this.start.setForeground(Styles.ERROR_COLOR);
                this.end.setForeground(Styles.ERROR_COLOR);
                this.days.setForeground(Styles.ERROR_COLOR);
            } else {
                this.startLabel.setFont(Styles.LABEL);
                this.endLabel.setFont(Styles.LABEL);
                this.startLabel.setForeground(Styles.DEFAULT_COLOR);
                this.endLabel.setForeground(Styles.DEFAULT_COLOR);
                this.start.setForeground(Styles.DEFAULT_COLOR);
                this.end.setForeground(Styles.DEFAULT_COLOR);
                this.days.setForeground(Styles.DEFAULT_COLOR);
            }
        } else if ("start".equals(evt.getPropertyName())) {
            this.startAbsolute.setText(this.FORMAT.format(new Date((Long)evt.getNewValue())));
        } else if ("end".equals(evt.getPropertyName())) {
            this.endAbsolute.setText(this.FORMAT.format(new Date((Long)evt.getNewValue())));
        } else if ("timeZone".equals(evt.getPropertyName())) {
            TimeZone timeZone = (TimeZone)evt.getNewValue();
            JSpinner.DateEditor de = (JSpinner.DateEditor)this.base.getEditor();
            de.getFormat().setTimeZone(timeZone);
            ((SpinnerDateModel)this.base.getModel()).setCalendarField(12);
            ((SpinnerDateModel)this.base.getModel()).setCalendarField(13);
            this.FORMAT.setTimeZone(timeZone);
            this.startAbsolute.setText(this.FORMAT.format(new Date(this.getStartTime())));
            this.endAbsolute.setText(this.FORMAT.format(new Date(this.getEndTime())));
        }
    }
}

