/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.summary.ChartSummaryPanel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public abstract class ChartSplitPane
extends JSplitPane
implements PropertyChangeListener,
DataSetListener {
    private static final long serialVersionUID = 7352498559598556656L;
    protected final NMONVisualizerGui gui;
    protected final ChartSummaryPanel summaryTable;
    private boolean changeInProgress;

    protected ChartSplitPane(NMONVisualizerGui gui, JFrame parent) {
        super(0);
        this.setResizeWeight(0.75);
        this.setOneTouchExpandable(true);
        this.setBorder(null);
        this.gui = gui;
        this.summaryTable = new ChartSummaryPanel(gui, parent, this.getDefaultColumns());
        this.changeInProgress = false;
        this.setBottomComponent(this.summaryTable);
        this.summaryTable.addPropertyChangeListener("selectedRows", this);
        this.summaryTable.addPropertyChangeListener("rowVisible", this);
    }

    public void displayTableColumnChooser() {
        this.summaryTable.displayTableColumnChooser();
    }

    protected String[] getDefaultColumns() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.summaryTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        BaseChartPanel chartPanel;
        if (this.changeInProgress) {
            return;
        }
        this.changeInProgress = true;
        if ("highlightedLine".equals(evt.getPropertyName())) {
            Integer newRow = (Integer)evt.getNewValue();
            if (newRow == null) {
                this.summaryTable.clearSelection();
            } else {
                this.summaryTable.selectRow(newRow);
            }
        } else if ("highlightedBar".equals(evt.getPropertyName())) {
            int[] newValues = (int[])evt.getNewValue();
            if (newValues == null) {
                this.summaryTable.clearSelection();
            } else {
                this.summaryTable.selectRow(newValues[0], newValues[1]);
            }
        } else if ("highlightedIntervalLine".equals(evt.getPropertyName())) {
            Integer newRow = (Integer)evt.getNewValue();
            if (newRow == null) {
                this.summaryTable.clearSelection();
            } else {
                this.summaryTable.selectRow(newRow);
            }
        } else if ("selectedRows".equals(evt.getPropertyName())) {
            BaseChartPanel chartPanel2 = this.getChartPanel();
            if (chartPanel2 != null) {
                boolean[] selectedRows = (boolean[])evt.getNewValue();
                chartPanel2.clearHighlightedElements();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!selectedRows[i]) continue;
                    int row = this.summaryTable.getDatasetRow(i);
                    int column = this.summaryTable.getDatasetColumn(i);
                    chartPanel2.highlightElement(row, column);
                }
            }
        } else if ("rowVisible".equals(evt.getPropertyName()) && (chartPanel = this.getChartPanel()) != null) {
            Object[] values = (Object[])evt.getNewValue();
            chartPanel.setElementVisible((Integer)values[0], (Integer)values[1], (Boolean)values[2]);
        }
        this.changeInProgress = false;
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    protected abstract BaseChartPanel getChartPanel();

    protected abstract void saveCharts(String var1);
}

