/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

final class ChartTableToggle
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 6311156984922819016L;
    private final NMONVisualizerGui gui;
    private final JRadioButton charts;
    private final JRadioButton table;

    public ChartTableToggle(NMONVisualizerGui gui) {
        super(new BorderLayout());
        this.gui = gui;
        this.charts = new JRadioButton("Charts");
        this.table = new JRadioButton("Table");
        this.charts.setFont(Styles.LABEL);
        this.table.setFont(Styles.LABEL);
        this.charts.setBorder(Styles.CONTENT_BORDER);
        this.table.setBorder(Styles.CONTENT_BORDER);
        this.charts.setActionCommand("Charts");
        this.table.setActionCommand("Table");
        ActionListener toggle = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartTableToggle.this.gui.setProperty("chartsDisplayed", !e.getActionCommand().equals("Table"));
            }
        };
        this.charts.addActionListener(toggle);
        this.table.addActionListener(toggle);
        ButtonGroup group = new ButtonGroup();
        group.add(this.charts);
        group.add(this.table);
        this.charts.setSelected(true);
        this.table.setSelected(false);
        this.add((Component)this.charts, "Before");
        this.add((Component)this.table, "After");
        gui.addPropertyChangeListener("chartsDisplayed", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chartsDisplayed".equals(evt.getPropertyName())) {
            boolean chartsDisplayed = (Boolean)evt.getNewValue();
            if (chartsDisplayed) {
                this.charts.setSelected(true);
            } else {
                this.table.setSelected(true);
            }
        }
    }
}

