/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.main.ChartSplitPane;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.report.ReportPanel;
import java.util.HashMap;
import java.util.Map;

final class DataSetView
extends ChartSplitPane {
    private static final long serialVersionUID = 6066688638520302421L;
    private final Map<String, ReportPanel> reportPanels = new HashMap<String, ReportPanel>();
    private ReportPanel currentReport;
    private String lastCommonTabName;

    DataSetView(NMONVisualizerGui gui) {
        super(gui, gui.getMainFrame());
        for (DataSet dataSet : gui.getDataSets()) {
            this.dataAdded(dataSet);
        }
        gui.addDataSetListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (this.currentReport != null) {
                this.currentReport.setEnabled(enabled);
            }
        }
    }

    @Override
    protected BaseChartPanel getChartPanel() {
        return this.currentReport == null ? null : this.currentReport.getChartPanel();
    }

    void setData(DataSet data) {
        ReportPanel forData = this.reportPanels.get(data.getHostname());
        String lastTabName = null;
        if (forData != this.currentReport) {
            int i;
            if (this.currentReport != null) {
                this.currentReport.setEnabled(false);
                lastTabName = this.currentReport.getTitleAt(this.currentReport.getSelectedIndex());
            }
            int location = this.getDividerLocation();
            this.currentReport = forData;
            boolean found = false;
            if (lastTabName != null) {
                for (i = 0; i < this.currentReport.getTabCount(); ++i) {
                    if (!this.currentReport.getTitleAt(i).equals(lastTabName)) continue;
                    if (this.currentReport.getSelectedIndex() != i) {
                        this.currentReport.setSelectedIndex(i);
                    }
                    this.lastCommonTabName = lastTabName;
                    found = true;
                    break;
                }
            }
            if (!found && this.lastCommonTabName != null) {
                for (i = 0; i < this.currentReport.getTabCount(); ++i) {
                    if (!this.currentReport.getTitleAt(i).equals(this.lastCommonTabName)) continue;
                    if (this.currentReport.getSelectedIndex() == i) break;
                    this.currentReport.setSelectedIndex(i);
                    break;
                }
            }
            this.setTopComponent(this.currentReport);
            this.setDividerLocation(location);
            if (this.isEnabled()) {
                this.currentReport.setEnabled(true);
            }
        }
    }

    @Override
    protected void saveCharts(String directory) {
        if (this.currentReport != null) {
            this.currentReport.saveAllCharts(directory);
        }
    }

    @Override
    public void dataAdded(DataSet data) {
        if (!this.reportPanels.containsKey(data.getHostname())) {
            ReportPanel reportPanel = new ReportPanel(this.gui, "dataset", data);
            reportPanel.addPropertyChangeListener("chart", this.summaryTable);
            reportPanel.addPropertyChangeListener("highlightedLine", this);
            reportPanel.addPropertyChangeListener("highlightedBar", this);
            reportPanel.addPropertyChangeListener("chart", this);
            reportPanel.addPropertyChangeListener("annotation", this);
            reportPanel.setEnabled(false);
            this.reportPanels.put(data.getHostname(), reportPanel);
        }
    }

    @Override
    public void dataRemoved(DataSet data) {
        ReportPanel forData = this.reportPanels.remove(data.getHostname());
        if (forData != null) {
            forData.dispose();
            if (forData == this.currentReport) {
                this.currentReport = null;
            }
        }
    }

    @Override
    public void dataChanged(DataSet data) {
        ReportPanel forData = this.reportPanels.get(data.getHostname());
        if (forData != null) {
            forData.resetReport();
        }
    }

    @Override
    public void dataCleared() {
        for (ReportPanel report : this.reportPanels.values()) {
            report.dispose();
        }
        this.reportPanels.clear();
        this.currentReport = null;
        this.setTopComponent(null);
    }

    @Override
    protected String[] getDefaultColumns() {
        return new String[]{"Series Name", "Minimum", "Average", "Maximum", "Std Dev"};
    }
}

