/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.main;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.gui.Styles;
import com.ibm.nmon.gui.chart.BaseChartPanel;
import com.ibm.nmon.gui.chart.DataTypeChartPanel;
import com.ibm.nmon.gui.main.ChartSplitPane;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.awt.Component;
import java.util.Collections;

final class DataTypeView
extends ChartSplitPane {
    private static final long serialVersionUID = -1143801614058577721L;
    private final DataTypeChartPanel chartPanel;

    DataTypeView(NMONVisualizerGui gui) {
        super(gui, gui.getMainFrame());
        this.chartPanel = new DataTypeChartPanel(gui);
        this.chartPanel.setBorder(Styles.createTopLineBorder(this));
        this.chartPanel.addPropertyChangeListener("chart", this.summaryTable);
        this.chartPanel.addPropertyChangeListener("highlightedLine", this);
        this.chartPanel.addPropertyChangeListener("chart", this);
        this.chartPanel.addPropertyChangeListener("annotation", this);
        gui.addDataSetListener(this);
        this.setTopComponent((Component)((Object)this.chartPanel));
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            this.chartPanel.setEnabled(enabled);
        }
    }

    @Override
    protected BaseChartPanel getChartPanel() {
        return this.chartPanel;
    }

    void setData(DataSet data, DataType type) {
        this.chartPanel.setData(data, type);
    }

    void setData(DataSet data, DataType type, String field) {
        this.chartPanel.setData(data, type, Collections.singletonList(field));
    }

    @Override
    protected void saveCharts(String directory) {
        this.chartPanel.saveChart(directory, null);
    }

    @Override
    public void dataAdded(DataSet data) {
    }

    @Override
    public void dataRemoved(DataSet data) {
        DataSet current = this.chartPanel.getData();
        if (current != null && current.equals(data)) {
            this.chartPanel.clearChart();
        }
    }

    @Override
    public void dataChanged(DataSet data) {
    }

    @Override
    public void dataCleared() {
        this.chartPanel.clearChart();
    }
}

